/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.commands.skills;

import java.util.function.Supplier;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;

public enum SkillAttributeBonus {
    ATTACK(Skill.ATTACK, () -> (Attribute)Attributes.ATTACK_DAMAGE.value(), () -> (Double)Configuration.ATTACK_DAMAGE_BONUS.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL),
    GATHERING(Skill.GATHERING, () -> null, () -> (Double)Configuration.GATHERING_XP_BONUS.get(), AttributeModifier.Operation.ADD_VALUE),
    MINING(Skill.MINING, () -> null, () -> (Double)Configuration.MINING_SPEED_MULTIPLIER.get(), AttributeModifier.Operation.ADD_VALUE),
    FARMING(Skill.FARMING, () -> null, () -> (Double)Configuration.CROP_GROWTH_CHANCE.get(), AttributeModifier.Operation.ADD_VALUE),
    BUILDING(Skill.BUILDING, () -> null, () -> (Double)Configuration.BLOCK_REACH_BONUS.get(), AttributeModifier.Operation.ADD_VALUE),
    DEFENSE(Skill.DEFENSE, () -> (Attribute)Attributes.ARMOR.value(), () -> (Double)Configuration.ARMOR_BONUS.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL),
    AGILITY(Skill.AGILITY, () -> null, () -> (Double)Configuration.MOVEMENT_SPEED_BONUS.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL),
    MAGIC(Skill.MAGIC, Configuration::getConfiguredMagicAttribute, () -> (Double)Configuration.LUCK_BONUS.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public final Skill skill;
    private final Supplier<Attribute> attributeSupplier;
    private final Supplier<Double> bonusSupplier;
    public final AttributeModifier.Operation operation;

    private SkillAttributeBonus(Skill skill, Supplier<Attribute> attributeSupplier, Supplier<Double> bonusSupplier, AttributeModifier.Operation operation) {
        this.skill = skill;
        this.attributeSupplier = attributeSupplier;
        this.bonusSupplier = bonusSupplier;
        this.operation = operation;
    }

    public double getBonusPerStep() {
        return this.bonusSupplier.get();
    }

    public Attribute getAttribute() {
        return this.attributeSupplier.get();
    }

    @Nullable
    public static SkillAttributeBonus getBySkill(Skill skill) {
        for (SkillAttributeBonus bonus : SkillAttributeBonus.values()) {
            if (bonus.skill != skill) continue;
            return bonus;
        }
        return null;
    }
}

