/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network.payload;

import java.util.EnumMap;
import java.util.Map;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record SyncToClient(Map<Skill, Integer> levels, Map<Skill, Boolean> disabledPerks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"sync_to_client");
    public static final CustomPacketPayload.Type<SyncToClient> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, Skill> SKILL_CODEC = StreamCodec.of((buf, skill) -> buf.writeEnum((Enum)skill), buf -> (Skill)buf.readEnum(Skill.class));
    public static final StreamCodec<FriendlyByteBuf, SyncToClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(size -> new EnumMap(Skill.class), SKILL_CODEC, (StreamCodec)ByteBufCodecs.INT), SyncToClient::levels, (StreamCodec)ByteBufCodecs.map(size -> new EnumMap(Skill.class), SKILL_CODEC, (StreamCodec)ByteBufCodecs.BOOL), SyncToClient::disabledPerks, SyncToClient::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void send(ServerPlayer player) {
        SkillModel model = SkillModel.get((Player)player);
        EnumMap<Skill, Integer> levels = new EnumMap<Skill, Integer>(Skill.class);
        EnumMap<Skill, Boolean> disabled = new EnumMap<Skill, Boolean>(Skill.class);
        for (Skill skill : Skill.values()) {
            levels.put(skill, model.getSkillLevel(skill));
            disabled.put(skill, !model.isPerkEnabled(skill));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncToClient(levels, disabled), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

