/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.TerracottaGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class ClayGolemStatueBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<ClayGolemStatueBlock> CODEC = ClayGolemStatueBlock.simpleCodec(ClayGolemStatueBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)9.6, (double)0.0, (double)3.0, (double)12.6, (double)3.0, (double)6.0), Block.box((double)3.5, (double)0.0, (double)3.0, (double)6.5, (double)3.0, (double)6.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)2.5, (double)0.0, (double)6.0, (double)4.5, (double)6.0, (double)10.0), Block.box((double)11.5, (double)0.0, (double)6.0, (double)13.5, (double)6.0, (double)10.0), Block.box((double)6.5, (double)2.0, (double)2.2, (double)9.5, (double)7.0, (double)4.2)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)10.0, (double)0.0, (double)9.6, (double)13.0, (double)3.0, (double)12.6), Block.box((double)10.0, (double)0.0, (double)3.5, (double)13.0, (double)3.0, (double)6.5), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)2.5, (double)10.0, (double)6.0, (double)4.5), Block.box((double)6.0, (double)0.0, (double)11.5, (double)10.0, (double)6.0, (double)13.5), Block.box((double)11.8, (double)2.0, (double)6.5, (double)13.8, (double)7.0, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)3.4, (double)0.0, (double)10.0, (double)6.4, (double)3.0, (double)13.0), Block.box((double)9.5, (double)0.0, (double)10.0, (double)12.5, (double)3.0, (double)13.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)11.5, (double)0.0, (double)6.0, (double)13.5, (double)6.0, (double)10.0), Block.box((double)2.5, (double)0.0, (double)6.0, (double)4.5, (double)6.0, (double)10.0), Block.box((double)6.5, (double)2.0, (double)11.8, (double)9.5, (double)7.0, (double)13.8)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.4, (double)6.0, (double)3.0, (double)6.4), Block.box((double)3.0, (double)0.0, (double)9.5, (double)6.0, (double)3.0, (double)12.5), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)11.5, (double)10.0, (double)6.0, (double)13.5), Block.box((double)6.0, (double)0.0, (double)2.5, (double)10.0, (double)6.0, (double)4.5), Block.box((double)2.2, (double)2.0, (double)6.5, (double)4.2, (double)7.0, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ClayGolemStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (level.hasNeighborSignal(pos)) {
            this.spawnGolem(level, pos, state);
            level.destroyBlock(pos, false);
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType().equals(Fluids.WATER)));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.BLOCK, pos) > 11 - state.getLightBlock((BlockGetter)level, pos)) {
            this.spawnGolem((Level)level, pos, state);
            return;
        }
        if (((Biome)level.getBiome(pos).value()).getBaseTemperature() > 1.0f) {
            this.spawnGolem((Level)level, pos, state);
        }
    }

    private void spawnGolem(Level level, BlockPos pos, BlockState state) {
        TerracottaGolem golem = (TerracottaGolem)((EntityType)ModEntityTypes.TERRACOTTA_GOLEM.get()).create(level);
        if (golem == null) {
            return;
        }
        golem.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, ((Direction)state.getValue((Property)FACING)).toYRot(), 0.0f);
        level.addFreshEntity((Entity)golem);
        level.destroyBlock(pos, false);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add(ConstantComponents.CLAY_GOLEM_STATUE_TOOLTIP);
    }
}

