/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.goals;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.entities.AdditionalBeeData;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HoneyGolem;
import tech.alexnijjar.golemoverhaul.mixins.common.BeeAccessor;

public class LocateHoneyGolemHiveGoal
extends Goal {
    private final Bee bee;
    private final BeeAccessor beeAccessor;

    public LocateHoneyGolemHiveGoal(Bee bee) {
        this.bee = bee;
        this.beeAccessor = (BeeAccessor)bee;
    }

    public boolean canUse() {
        return this.beeAccessor.getRemainingCooldownBeforeLocatingNewHive() < 20 && !((AdditionalBeeData)this.bee).golemoverhaul$hasGolemHive() && this.beeAccessor.invokeWantsToEnterHive();
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.beeAccessor.setRemainingCooldownBeforeLocatingNewHive(200);
        HoneyGolem golem = this.findHive();
        if (golem != null) {
            ((AdditionalBeeData)this.bee).golemoverhaul$setOwner(golem.getUUID());
        }
    }

    @Nullable
    private HoneyGolem findHive() {
        return this.bee.level().getEntitiesOfClass(HoneyGolem.class, this.bee.getBoundingBox().inflate(128.0)).stream().min((g1, g2) -> Double.compare(this.bee.distanceTo((Entity)g1), this.bee.distanceTo((Entity)g2))).orElse(null);
    }
}

