/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.util.RenderUtils;
import tech.alexnijjar.golemoverhaul.GolemOverhaul;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.SlimeGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class SlimeGolemRenderer
extends BaseGolemRenderer<SlimeGolem> {
    public static final ResourceLocation LARGE_TEXTURE = GolemOverhaul.asResource("textures/entity/slime/slime_golem.png");
    public static final ResourceLocation SMALL_TEXTURE = GolemOverhaul.asResource("textures/entity/slime/small_slime_golem.png");
    public static final ResourceLocation LARGE_MODEL = GolemOverhaul.asResource("geo/entity/slime/slime_golem.geo.json");
    public static final ResourceLocation SMALL_MODEL = GolemOverhaul.asResource("geo/entity/slime/small_slime_golem.geo.json");

    public SlimeGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<SlimeGolem>(ModEntityTypes.SLIME_GOLEM, false, 0){

            public ResourceLocation getModelResource(SlimeGolem golem) {
                return golem.getSize().isLarge() ? LARGE_MODEL : SMALL_MODEL;
            }
        });
    }

    public ResourceLocation getTextureLocation(SlimeGolem golem) {
        return golem.getSize().isLarge() ? LARGE_TEXTURE : SMALL_TEXTURE;
    }

    @Nullable
    public RenderType getRenderType(SlimeGolem animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public void renderRecursively(PoseStack poseStack, SlimeGolem golem, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean isInnerBodyBone = "body_2".equals(bone.getName());
        if (isInnerBodyBone) {
            float healthPercent = 0.5f + Mth.m_14036_((float)(golem.m_21223_() / 2.0f / golem.m_21233_()), (float)0.0f, (float)0.5f);
            poseStack.m_85836_();
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            poseStack.m_85841_(healthPercent, healthPercent, healthPercent);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        }
        super.renderRecursively(poseStack, (Entity)golem, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (isInnerBodyBone) {
            poseStack.m_85849_();
        }
    }
}

