/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.IShearable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.MudBallProjectile;
import tech.alexnijjar.golemoverhaul.common.tags.ModItemTags;

public class TerracottaGolem
extends BaseGolem
implements IShearable,
RangedAttackMob {
    public static final int RANGED_ATTACK_DELAY_TICKS = 2;
    private static final EntityDataAccessor<Byte> ID_TYPE = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f);
    private int attackAnimationDelay = -1;
    private ItemStack equippedStack = ItemStack.f_41583_;

    public TerracottaGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (double)Type.CACTUS.attackDamage);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnTerracottaGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("type", this.getTerracottaType().name().toLowerCase(Locale.ROOT));
        if (!this.equippedStack.m_41619_()) {
            compound.m_128365_("item", (Tag)this.equippedStack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTerracottaType(Type.valueOf(compound.m_128461_("type").toUpperCase(Locale.ROOT)));
        if (compound.m_128425_("item", 10)) {
            this.equippedStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("item"));
        }
    }

    @Override
    public boolean canMeleeAttack() {
        return !this.getTerracottaType().ranged;
    }

    public Type getTerracottaType() {
        return Type.values()[(Byte)this.f_19804_.m_135370_(ID_TYPE)];
    }

    public void setTerracottaType(Type type) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)((byte)type.ordinal()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)type.attackDamage);
        this.m_21051_(Attributes.f_22278_).m_22100_((double)type.knockbackResistance);
        this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
        if (type.ranged) {
            this.f_21345_.m_25352_(2, (Goal)this.rangedAttackGoal);
        }
        this.updateAttackGoals();
    }

    @Override
    public int getAttackTicks() {
        return 12;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42461_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 4.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_12447_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setTerracottaType(Type.values()[level.m_213780_().m_188503_(Type.values().length)]);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack;
        Type type;
        if (this.getTerracottaType() == Type.NORMAL && !this.m_9236_().m_5776_() && (type = Type.ofStack(stack = player.m_21120_(hand))) != null) {
            this.equippedStack = stack.m_255036_(1);
            stack.m_41774_(1);
            this.m_216990_(SoundEvents.f_11675_);
            this.setTerracottaType(type);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    @NotNull
    public List<ItemStack> onSheared() {
        this.m_216990_(SoundEvents.f_12480_);
        this.setTerracottaType(Type.NORMAL);
        if (!this.equippedStack.m_41619_()) {
            return List.of(this.equippedStack);
        }
        return List.of(this.getTerracottaType().equipItem.m_7968_());
    }

    @Override
    public boolean isShearable() {
        return this.getTerracottaType() != Type.NORMAL;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (!this.m_9236_().m_5776_() && this.getTerracottaType() == Type.CACTUS && !source.m_276093_(DamageTypes.f_268440_) && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.m_6469_(this.m_269291_().m_269374_((Entity)this), 6.0f);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float velocity) {
        if (this.attackAnimationDelay == -1) {
            this.sendAttackEvent();
            this.attackAnimationDelay = 2;
        }
    }

    public void actuallyShoot(LivingEntity target) {
        if (target == null) {
            return;
        }
        MudBallProjectile projectile = new MudBallProjectile(this.m_9236_(), (LivingEntity)this);
        projectile.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20186_() - projectile.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.m_6686_(x, y + distance, z, 1.0f, 5.0f);
        this.m_9236_().m_7967_((Entity)projectile);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    protected void m_8024_() {
        this.attackAnimationDelay = Math.max(-1, this.attackAnimationDelay - 1);
        if (this.attackAnimationDelay == 0) {
            this.actuallyShoot(this.m_5448_());
            this.attackAnimationDelay = -1;
        }
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(0.5, 0.0, 0.5);
    }

    public static enum Type {
        NORMAL(2.0f, 0.0f, Items.f_41852_, false, stack -> false),
        CACTUS(6.0f, 1.0f, Items.f_41982_, false, stack -> stack.m_204117_(ModItemTags.CACTUS)),
        DEAD_BUSH(4.0f, 0.0f, Items.f_41866_, true, stack -> stack.m_150930_(Items.f_41866_));

        private final float attackDamage;
        private final float knockbackResistance;
        private final Item equipItem;
        private final boolean ranged;
        private final Predicate<ItemStack> isValidStack;

        private Type(float attackDamage, float knockbackResistance, Item equipItem, boolean ranged, Predicate<ItemStack> isValidStack) {
            this.attackDamage = attackDamage;
            this.knockbackResistance = knockbackResistance;
            this.equipItem = equipItem;
            this.ranged = ranged;
            this.isValidStack = isValidStack;
        }

        @Nullable
        private static Type ofStack(ItemStack stack) {
            for (Type type : Type.values()) {
                if (!type.isValidStack.test(stack)) continue;
                return type;
            }
            return null;
        }
    }
}

