/*
 * Decompiled with CFR 0.152.
 */
package com.encantamientosop.mod.events;

import com.encantamientosop.mod.enchantments.ModEnchantments;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class EnchantmentEvents {
    private final Random random = new Random();

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        Player player;
        ItemStack boots;
        int noFallLevel;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (noFallLevel = ModEnchantments.level(boots = (player = (Player)livingEntity).getItemBySlot(EquipmentSlot.FEET), player.level(), ModEnchantments.NO_FALL)) > 0) {
            float reduction = Math.min(1.0f, (float)noFallLevel * 0.4f);
            event.setDamageMultiplier(event.getDamageMultiplier() * (1.0f - reduction));
            if (noFallLevel >= 3) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent event) {
        Player player;
        int antiKb;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (antiKb = ModEnchantments.level((player = (Player)livingEntity).getItemBySlot(EquipmentSlot.CHEST), player.level(), ModEnchantments.ANTI_KNOCKBACK)) > 0) {
            float factor = Math.max(0.0f, 1.0f - 0.3f * (float)antiKb);
            event.setStrength(event.getStrength() * factor);
            if (antiKb >= 3) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        this.handleAutoRepair(player);
        this.handleFly(player);
    }

    private void handleAutoRepair(Player player) {
        ItemStack stack;
        int i;
        if (player.level().isClientSide) {
            return;
        }
        boolean fastTick = false;
        Inventory inv = player.getInventory();
        for (i = 0; i < inv.getContainerSize(); ++i) {
            int lvl;
            stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.isDamaged() || (lvl = ModEnchantments.level(stack, player.level(), ModEnchantments.AUTO_REPAIR)) < 6) continue;
            fastTick = true;
        }
        if (fastTick && player.tickCount % 50 != 0 || !fastTick && player.tickCount % 100 != 0) {
            return;
        }
        for (i = 0; i < inv.getContainerSize(); ++i) {
            int autoRepairLevel;
            stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.isDamaged() || (autoRepairLevel = ModEnchantments.level(stack, player.level(), ModEnchantments.AUTO_REPAIR)) <= 0) continue;
            float chance = (float)autoRepairLevel * 0.1f;
            int repairAmount = autoRepairLevel;
            if (autoRepairLevel >= 6) {
                chance = Math.min(1.0f, 0.6f);
                repairAmount = autoRepairLevel * 2;
            }
            if (!(this.random.nextFloat() < chance)) continue;
            stack.setDamageValue(Math.max(0, stack.getDamageValue() - repairAmount));
        }
    }

    private void handleFly(Player player) {
        ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
        int flyLevel = ModEnchantments.level(chestplate, player.level(), ModEnchantments.FLY);
        if (flyLevel > 0 && !player.isCreative() && !player.isSpectator()) {
            player.getAbilities().mayfly = true;
            float flySpeed = 0.05f + (float)flyLevel * 0.02f;
            player.getAbilities().setFlyingSpeed(flySpeed);
            player.onUpdateAbilities();
        } else if (!player.isCreative() && !player.isSpectator()) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
            player.getAbilities().setFlyingSpeed(0.05f);
            player.onUpdateAbilities();
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        int teleportLevel = ModEnchantments.level(stack, player.level(), ModEnchantments.TELEPORT);
        if (teleportLevel > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Vec3 eyePos = player.getEyePosition();
            Vec3 lookVec = player.getLookAngle();
            double range = 32.0 + (double)teleportLevel * 16.0;
            Vec3 endPos = eyePos.add(lookVec.scale(range));
            ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult result = player.level().clip(context);
            if (result.getType() == HitResult.Type.BLOCK) {
                BlockPos targetPos = result.getBlockPos().above();
                if (player.level().getBlockState(targetPos).isAir() && player.level().getBlockState(targetPos.above()).isAir()) {
                    serverPlayer.teleportTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
                    EquipmentSlot slot = event.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    stack.hurtAndBreak(1, (LivingEntity)player, slot);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickExtras(PlayerTickEvent.Post event) {
        int xpMagnet;
        int haste;
        int waterMastery;
        FoodData food;
        int autoFeed;
        int fireImmune;
        int magnetLevel;
        int speedLevel;
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        int nightVisionLevel = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.HEAD), player.level(), ModEnchantments.NIGHT_VISION);
        if (nightVisionLevel > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 220, 0, true, false));
        }
        if ((speedLevel = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.FEET), player.level(), ModEnchantments.SPEED)) > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, Math.max(0, speedLevel - 1), true, false));
        }
        if ((magnetLevel = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.CHEST), player.level(), ModEnchantments.MAGNET)) > 0 && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            double radius = 3.0 + (double)magnetLevel * 2.0;
            List items = player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(radius));
            for (ItemEntity itemEntity : items) {
                if (itemEntity.hasPickUpDelay()) continue;
                sp.take((Entity)itemEntity, itemEntity.getItem().getCount());
            }
        }
        if ((fireImmune = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.CHEST), player.level(), ModEnchantments.FIRE_IMMUNITY)) > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 220, 0, true, false));
            player.clearFire();
        }
        if ((autoFeed = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.CHEST), player.level(), ModEnchantments.AUTO_FEED)) > 0 && player.tickCount % 80 == 0 && (food = player.getFoodData()).getFoodLevel() < 20) {
            food.eat(1, 0.2f * (float)autoFeed);
        }
        if ((waterMastery = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.FEET), player.level(), ModEnchantments.WATER_MASTERY)) > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 220, 0, true, false));
            player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 120, Math.max(0, waterMastery - 1), true, false));
        }
        if ((haste = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.MAINHAND), player.level(), ModEnchantments.HASTE_OP)) > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 120, Math.max(0, haste - 1), true, false));
        }
        if ((xpMagnet = ModEnchantments.level(player.getItemBySlot(EquipmentSlot.CHEST), player.level(), ModEnchantments.XP_MAGNET)) > 0 && player instanceof ServerPlayer) {
            ServerPlayer sp2 = (ServerPlayer)player;
            double radius2 = 3.0 + (double)xpMagnet * 2.0;
            List xps = player.level().getEntitiesOfClass(ExperienceOrb.class, player.getBoundingBox().inflate(radius2));
            for (ExperienceOrb xp : xps) {
                xp.playerTouch((Player)sp2);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingIncomingDamageEvent event) {
        Entity attacker;
        Player player2;
        int reflect;
        Player player;
        LivingEntity weapon;
        int lifestealLevel;
        DamageContainer container = event.getContainer();
        Entity entity = container.getSource().getEntity();
        if (entity instanceof Player && (lifestealLevel = ModEnchantments.level((ItemStack)(weapon = (player = (Player)entity).getItemBySlot(EquipmentSlot.MAINHAND)), player.level(), ModEnchantments.LIFESTEAL)) > 0 && !player.level().isClientSide) {
            float heal = Math.max(0.5f, container.getNewDamage() * (0.1f * (float)lifestealLevel));
            player.heal(heal);
        }
        if ((weapon = event.getEntity()) instanceof Player && (reflect = ModEnchantments.level((player2 = (Player)weapon).getItemBySlot(EquipmentSlot.CHEST), player2.level(), ModEnchantments.REFLECT_DAMAGE)) > 0 && (attacker = container.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)attacker;
            float pct = 0.1f * (float)reflect;
            le.hurt(le.damageSources().generic(), container.getNewDamage() * pct);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int prosperity;
        int veinLevel;
        int aoeLevel;
        Player player = event.getPlayer();
        if (player == null || player.level().isClientSide) {
            return;
        }
        ItemStack tool = player.getItemBySlot(EquipmentSlot.MAINHAND);
        int autoSmeltLevel = ModEnchantments.level(tool, player.level(), ModEnchantments.AUTO_SMELT);
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        HashMap<Block, Item> smeltMap = new HashMap<Block, Item>();
        smeltMap.put(Blocks.IRON_ORE, Items.IRON_INGOT);
        smeltMap.put(Blocks.DEEPSLATE_IRON_ORE, Items.IRON_INGOT);
        smeltMap.put(Blocks.GOLD_ORE, Items.GOLD_INGOT);
        smeltMap.put(Blocks.DEEPSLATE_GOLD_ORE, Items.GOLD_INGOT);
        smeltMap.put(Blocks.COPPER_ORE, Items.COPPER_INGOT);
        smeltMap.put(Blocks.ANCIENT_DEBRIS, Items.NETHERITE_SCRAP);
        Item item = (Item)smeltMap.get(state.getBlock());
        if (item != null && autoSmeltLevel > 0) {
            event.setCanceled(true);
            level.removeBlock(pos, false);
            int count = 1 + level.random.nextInt(Math.max(1, autoSmeltLevel));
            ItemEntity drop = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)item, count));
            level.addFreshEntity((Entity)drop);
            tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        if ((aoeLevel = ModEnchantments.level(tool, player.level(), ModEnchantments.MINING_AOE)) > 0) {
            int radius = aoeLevel;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos p2;
                        BlockState st2;
                        if (dx == 0 && dy == 0 && dz == 0 || (st2 = level.getBlockState(p2 = pos.offset(dx, dy, dz))).isAir() || !(st2.getDestroySpeed((BlockGetter)level, p2) >= 0.0f)) continue;
                        level.destroyBlock(p2, true, (Entity)player);
                    }
                }
            }
        }
        if ((veinLevel = ModEnchantments.level(tool, player.level(), ModEnchantments.VEIN_MINER)) > 0) {
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
            visited.add(pos);
            q.add(pos);
            int broken = 0;
            int limit = 8 * veinLevel;
            Block startBlock = state.getBlock();
            while (!q.isEmpty() && broken < limit) {
                BlockPos cur = (BlockPos)q.poll();
                for (Direction dir : Direction.values()) {
                    BlockState st;
                    BlockPos np = cur.relative(dir);
                    if (!visited.add(np) || (st = level.getBlockState(np)).getBlock() != startBlock) continue;
                    level.destroyBlock(np, true, (Entity)player);
                    ++broken;
                    q.add(np);
                }
            }
        }
        if ((prosperity = ModEnchantments.level(tool, player.level(), ModEnchantments.PROSPERITY)) > 0) {
            HashMap<Block, Item> rawMap = new HashMap<Block, Item>();
            rawMap.put(Blocks.IRON_ORE, Items.RAW_IRON);
            rawMap.put(Blocks.DEEPSLATE_IRON_ORE, Items.RAW_IRON);
            rawMap.put(Blocks.GOLD_ORE, Items.RAW_GOLD);
            rawMap.put(Blocks.DEEPSLATE_GOLD_ORE, Items.RAW_GOLD);
            rawMap.put(Blocks.COPPER_ORE, Items.RAW_COPPER);
            rawMap.put(Blocks.DEEPSLATE_COPPER_ORE, Items.RAW_COPPER);
            rawMap.put(Blocks.COAL_ORE, Items.COAL);
            rawMap.put(Blocks.DEEPSLATE_COAL_ORE, Items.COAL);
            rawMap.put(Blocks.LAPIS_ORE, Items.LAPIS_LAZULI);
            rawMap.put(Blocks.DEEPSLATE_LAPIS_ORE, Items.LAPIS_LAZULI);
            rawMap.put(Blocks.REDSTONE_ORE, Items.REDSTONE);
            rawMap.put(Blocks.DEEPSLATE_REDSTONE_ORE, Items.REDSTONE);
            rawMap.put(Blocks.DIAMOND_ORE, Items.DIAMOND);
            rawMap.put(Blocks.DEEPSLATE_DIAMOND_ORE, Items.DIAMOND);
            rawMap.put(Blocks.EMERALD_ORE, Items.EMERALD);
            rawMap.put(Blocks.DEEPSLATE_EMERALD_ORE, Items.EMERALD);
            Item bonusItem = (Item)rawMap.get(state.getBlock());
            if (bonusItem != null) {
                int mult = 1 + player.level().random.nextInt(Math.max(1, prosperity + 1));
                ItemEntity drop = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)bonusItem, mult));
                level.addFreshEntity((Entity)drop);
            }
        }
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        Player player;
        ItemStack weapon;
        int xpBoostLevel;
        if (event.getAttackingPlayer() != null && (xpBoostLevel = ModEnchantments.level(weapon = (player = event.getAttackingPlayer()).getItemBySlot(EquipmentSlot.MAINHAND), player.level(), ModEnchantments.XP_BOOST)) > 0) {
            int base = event.getOriginalExperience();
            int bonus = (int)Math.ceil((double)base * (0.25 * (double)xpBoostLevel));
            event.setDroppedExperience(base + bonus);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            int superLoot;
            Player player = (Player)entity;
            ItemStack weapon = player.getItemBySlot(EquipmentSlot.MAINHAND);
            int beheadingLevel = ModEnchantments.level(weapon, player.level(), ModEnchantments.BEHEADING);
            if (beheadingLevel > 0 && !player.level().isClientSide) {
                LivingEntity mob = event.getEntity();
                ArrayList<ItemStack> extra = new ArrayList<ItemStack>();
                double chance = 0.1 * (double)beheadingLevel;
                if (mob.getType() == EntityType.SKELETON && player.level().random.nextDouble() < chance) {
                    extra.add(new ItemStack((ItemLike)Items.SKELETON_SKULL));
                } else if (mob.getType() == EntityType.ZOMBIE && player.level().random.nextDouble() < chance) {
                    extra.add(new ItemStack((ItemLike)Items.ZOMBIE_HEAD));
                } else if (mob.getType() == EntityType.CREEPER && player.level().random.nextDouble() < chance) {
                    extra.add(new ItemStack((ItemLike)Items.CREEPER_HEAD));
                } else if (mob.getType() == EntityType.PIGLIN && player.level().random.nextDouble() < chance) {
                    extra.add(new ItemStack((ItemLike)Items.PIGLIN_HEAD));
                }
                for (ItemStack stack : extra) {
                    event.getDrops().add(new ItemEntity(player.level(), mob.getX(), mob.getY(), mob.getZ(), stack));
                }
            }
            if ((superLoot = ModEnchantments.level(weapon, player.level(), ModEnchantments.SUPER_LOOT)) > 0) {
                for (ItemEntity ent : event.getDrops()) {
                    ItemStack st = ent.getItem();
                    int add = Math.max(0, superLoot);
                    st.setCount(st.getCount() + add);
                }
            }
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player player = event.getEntity();
        Inventory inv = original.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            int soul;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || (soul = ModEnchantments.level(stack, player.level(), ModEnchantments.SOULBOUND)) <= 0) continue;
            player.getInventory().add(stack.copy());
        }
    }
}

