/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.winterdropruined.entity;

import net.mcreator.winterdropruined.procedures.CreeperNautilusAnimationBoomProcedure;
import net.mcreator.winterdropruined.procedures.CreeperNautilusAnimationIdleProcedure;
import net.mcreator.winterdropruined.procedures.CreeperNautilusAnimationSwimProcedure;
import net.mcreator.winterdropruined.procedures.CreeperNautilusEntityIsHurtProcedure;
import net.mcreator.winterdropruined.procedures.CreeperNautilusOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class CreeperNautilusEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_saddle_equipped = SynchedEntityData.defineId(CreeperNautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_boom = SynchedEntityData.defineId(CreeperNautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_dash_iterator = SynchedEntityData.defineId(CreeperNautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public CreeperNautilusEntity(EntityType<CreeperNautilusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (CreeperNautilusEntity.this.isInWater()) {
                    CreeperNautilusEntity.this.setDeltaMovement(CreeperNautilusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !CreeperNautilusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - CreeperNautilusEntity.this.getX();
                    double dy = this.wantedY - CreeperNautilusEntity.this.getY();
                    double dz = this.wantedZ - CreeperNautilusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * CreeperNautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    CreeperNautilusEntity.this.setYRot(this.rotlerp(CreeperNautilusEntity.this.getYRot(), f, 10.0f));
                    CreeperNautilusEntity.this.yBodyRot = CreeperNautilusEntity.this.getYRot();
                    CreeperNautilusEntity.this.yHeadRot = CreeperNautilusEntity.this.getYRot();
                    if (CreeperNautilusEntity.this.isInWater()) {
                        CreeperNautilusEntity.this.setSpeed((float)CreeperNautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        CreeperNautilusEntity.this.setXRot(this.rotlerp(CreeperNautilusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(CreeperNautilusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        CreeperNautilusEntity.this.setZza(f3 * f1);
                        CreeperNautilusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        CreeperNautilusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    CreeperNautilusEntity.this.setSpeed(0.0f);
                    CreeperNautilusEntity.this.setYya(0.0f);
                    CreeperNautilusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_saddle_equipped, (Object)false);
        builder.define(DATA_boom, (Object)0);
        builder.define(DATA_dash_iterator, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.creeper.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CreeperNautilusEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        CreeperNautilusEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datasaddle_equipped", ((Boolean)this.entityData.get(DATA_saddle_equipped)).booleanValue());
        compound.putInt("Databoom", ((Integer)this.entityData.get(DATA_boom)).intValue());
        compound.putInt("Datadash_iterator", ((Integer)this.entityData.get(DATA_dash_iterator)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datasaddle_equipped")) {
            this.entityData.set(DATA_saddle_equipped, (Object)compound.getBoolean("Datasaddle_equipped"));
        }
        if (compound.contains("Databoom")) {
            this.entityData.set(DATA_boom, (Object)compound.getInt("Databoom"));
        }
        if (compound.contains("Datadash_iterator")) {
            this.entityData.set(DATA_dash_iterator, (Object)compound.getInt("Datadash_iterator"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(CreeperNautilusAnimationIdleProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CreeperNautilusAnimationSwimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CreeperNautilusAnimationBoomProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CreeperNautilusOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CreeperNautilusEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CreeperNautilusEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 15.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

