/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.winterdropruined.entity;

import javax.annotation.Nullable;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation0Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation1Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation2Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation3Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation4Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusAnimation5Procedure;
import net.mcreator.winterdropruined.procedures.KrakentilusEntityDiesProcedure;
import net.mcreator.winterdropruined.procedures.KrakentilusEntityIsHurtProcedure;
import net.mcreator.winterdropruined.procedures.KrakentilusIdleConditionProcedure;
import net.mcreator.winterdropruined.procedures.KrakentilusOnEntityTickUpdateProcedure;
import net.mcreator.winterdropruined.procedures.KrakentilusOnInitialEntitySpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class KrakentilusEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_dash_iterator = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_skill_iterator = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_phase = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_sleep_rotation = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_rising_animation = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_still_position_x = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_still_position_z = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_boss_bar_iterator = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_idle_despawn_iterator = SynchedEntityData.defineId(KrakentilusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public KrakentilusEntity(EntityType<KrakentilusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (KrakentilusEntity.this.isInWater()) {
                    KrakentilusEntity.this.setDeltaMovement(KrakentilusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !KrakentilusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - KrakentilusEntity.this.getX();
                    double dy = this.wantedY - KrakentilusEntity.this.getY();
                    double dz = this.wantedZ - KrakentilusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * KrakentilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    KrakentilusEntity.this.setYRot(this.rotlerp(KrakentilusEntity.this.getYRot(), f, 10.0f));
                    KrakentilusEntity.this.yBodyRot = KrakentilusEntity.this.getYRot();
                    KrakentilusEntity.this.yHeadRot = KrakentilusEntity.this.getYRot();
                    if (KrakentilusEntity.this.isInWater()) {
                        KrakentilusEntity.this.setSpeed((float)KrakentilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        KrakentilusEntity.this.setXRot(this.rotlerp(KrakentilusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(KrakentilusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        KrakentilusEntity.this.setZza(f3 * f1);
                        KrakentilusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        KrakentilusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    KrakentilusEntity.this.setSpeed(0.0f);
                    KrakentilusEntity.this.setYya(0.0f);
                    KrakentilusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_dash_iterator, (Object)0);
        builder.define(DATA_skill_iterator, (Object)0);
        builder.define(DATA_phase, (Object)0);
        builder.define(DATA_sleep_rotation, (Object)0);
        builder.define(DATA_rising_animation, (Object)100);
        builder.define(DATA_still_position_x, (Object)0);
        builder.define(DATA_still_position_z, (Object)0);
        builder.define(DATA_boss_bar_iterator, (Object)5);
        builder.define(DATA_idle_despawn_iterator, (Object)9600);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean canUse() {
                double x = KrakentilusEntity.this.getX();
                double y = KrakentilusEntity.this.getY();
                double z = KrakentilusEntity.this.getZ();
                KrakentilusEntity entity = KrakentilusEntity.this;
                Level world = KrakentilusEntity.this.level();
                return super.canUse() && KrakentilusIdleConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = KrakentilusEntity.this.getX();
                double y = KrakentilusEntity.this.getY();
                double z = KrakentilusEntity.this.getZ();
                KrakentilusEntity entity = KrakentilusEntity.this;
                Level world = KrakentilusEntity.this.level();
                return super.canUse() && KrakentilusIdleConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 14.0f){

            public boolean canUse() {
                double x = KrakentilusEntity.this.getX();
                double y = KrakentilusEntity.this.getY();
                double z = KrakentilusEntity.this.getZ();
                KrakentilusEntity entity = KrakentilusEntity.this;
                Level world = KrakentilusEntity.this.level();
                return super.canUse() && KrakentilusIdleConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = KrakentilusEntity.this.getX();
                double y = KrakentilusEntity.this.getY();
                double z = KrakentilusEntity.this.getZ();
                KrakentilusEntity entity = KrakentilusEntity.this;
                Level world = KrakentilusEntity.this.level();
                return super.canUse() && KrakentilusIdleConditionProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        KrakentilusEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        KrakentilusEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, sourceentity);
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        KrakentilusEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        KrakentilusOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datadash_iterator", ((Integer)this.entityData.get(DATA_dash_iterator)).intValue());
        compound.putInt("Dataskill_iterator", ((Integer)this.entityData.get(DATA_skill_iterator)).intValue());
        compound.putInt("Dataphase", ((Integer)this.entityData.get(DATA_phase)).intValue());
        compound.putInt("Datasleep_rotation", ((Integer)this.entityData.get(DATA_sleep_rotation)).intValue());
        compound.putInt("Datarising_animation", ((Integer)this.entityData.get(DATA_rising_animation)).intValue());
        compound.putInt("Datastill_position_x", ((Integer)this.entityData.get(DATA_still_position_x)).intValue());
        compound.putInt("Datastill_position_z", ((Integer)this.entityData.get(DATA_still_position_z)).intValue());
        compound.putInt("Databoss_bar_iterator", ((Integer)this.entityData.get(DATA_boss_bar_iterator)).intValue());
        compound.putInt("Dataidle_despawn_iterator", ((Integer)this.entityData.get(DATA_idle_despawn_iterator)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datadash_iterator")) {
            this.entityData.set(DATA_dash_iterator, (Object)compound.getInt("Datadash_iterator"));
        }
        if (compound.contains("Dataskill_iterator")) {
            this.entityData.set(DATA_skill_iterator, (Object)compound.getInt("Dataskill_iterator"));
        }
        if (compound.contains("Dataphase")) {
            this.entityData.set(DATA_phase, (Object)compound.getInt("Dataphase"));
        }
        if (compound.contains("Datasleep_rotation")) {
            this.entityData.set(DATA_sleep_rotation, (Object)compound.getInt("Datasleep_rotation"));
        }
        if (compound.contains("Datarising_animation")) {
            this.entityData.set(DATA_rising_animation, (Object)compound.getInt("Datarising_animation"));
        }
        if (compound.contains("Datastill_position_x")) {
            this.entityData.set(DATA_still_position_x, (Object)compound.getInt("Datastill_position_x"));
        }
        if (compound.contains("Datastill_position_z")) {
            this.entityData.set(DATA_still_position_z, (Object)compound.getInt("Datastill_position_z"));
        }
        if (compound.contains("Databoss_bar_iterator")) {
            this.entityData.set(DATA_boss_bar_iterator, (Object)compound.getInt("Databoss_bar_iterator"));
        }
        if (compound.contains("Dataidle_despawn_iterator")) {
            this.entityData.set(DATA_idle_despawn_iterator, (Object)compound.getInt("Dataidle_despawn_iterator"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(KrakentilusAnimation0Procedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(KrakentilusAnimation1Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(KrakentilusAnimation2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(KrakentilusAnimation3Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(KrakentilusAnimation4Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(KrakentilusAnimation5Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        KrakentilusOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        KrakentilusEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        KrakentilusEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 12.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

