/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.winterdropruined.entity;

import javax.annotation.Nullable;
import net.mcreator.winterdropruined.procedures.TentalceAnimation0Procedure;
import net.mcreator.winterdropruined.procedures.TentalceAnimation1Procedure;
import net.mcreator.winterdropruined.procedures.TentalceAnimation2Procedure;
import net.mcreator.winterdropruined.procedures.TentalceAnimation3Procedure;
import net.mcreator.winterdropruined.procedures.TentalceAnimation4Procedure;
import net.mcreator.winterdropruined.procedures.TentalceAnimationHideProcedure;
import net.mcreator.winterdropruined.procedures.TentalceOnEntityTickUpdateProcedure;
import net.mcreator.winterdropruined.procedures.TentalceOnInitialEntitySpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class TentalceEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_despawn_iterator = SynchedEntityData.defineId(TentalceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_animation_type = SynchedEntityData.defineId(TentalceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public TentalceEntity(EntityType<TentalceEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (TentalceEntity.this.isInWater()) {
                    TentalceEntity.this.setDeltaMovement(TentalceEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !TentalceEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - TentalceEntity.this.getX();
                    double dy = this.wantedY - TentalceEntity.this.getY();
                    double dz = this.wantedZ - TentalceEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * TentalceEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    TentalceEntity.this.setYRot(this.rotlerp(TentalceEntity.this.getYRot(), f, 10.0f));
                    TentalceEntity.this.yBodyRot = TentalceEntity.this.getYRot();
                    TentalceEntity.this.yHeadRot = TentalceEntity.this.getYRot();
                    if (TentalceEntity.this.isInWater()) {
                        TentalceEntity.this.setSpeed((float)TentalceEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        TentalceEntity.this.setXRot(this.rotlerp(TentalceEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(TentalceEntity.this.getXRot() * ((float)Math.PI / 180)));
                        TentalceEntity.this.setZza(f3 * f1);
                        TentalceEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        TentalceEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    TentalceEntity.this.setSpeed(0.0f);
                    TentalceEntity.this.setYya(0.0f);
                    TentalceEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_despawn_iterator, (Object)600);
        builder.define(DATA_animation_type, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"winter_drop_ruined:nautilus_death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        TentalceOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datadespawn_iterator", ((Integer)this.entityData.get(DATA_despawn_iterator)).intValue());
        compound.putInt("Dataanimation_type", ((Integer)this.entityData.get(DATA_animation_type)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datadespawn_iterator")) {
            this.entityData.set(DATA_despawn_iterator, (Object)compound.getInt("Datadespawn_iterator"));
        }
        if (compound.contains("Dataanimation_type")) {
            this.entityData.set(DATA_animation_type, (Object)compound.getInt("Dataanimation_type"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(TentalceAnimation0Procedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(TentalceAnimation1Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(TentalceAnimation2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(TentalceAnimation3Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(TentalceAnimation4Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(TentalceAnimationHideProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        TentalceOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TentalceEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TentalceEntity entity = this;
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 2.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

