/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.winterdropruined.init;

import net.mcreator.winterdropruined.potion.BonusHealthOverMaxHealthMobEffect;
import net.mcreator.winterdropruined.potion.DrowningEffectMobEffect;
import net.mcreator.winterdropruined.potion.KrakentilusBossBarEffectMobEffect;
import net.mcreator.winterdropruined.potion.KrakentilusShellEffectMobEffect;
import net.mcreator.winterdropruined.potion.PufferNautilusBackwardEffectMobEffect;
import net.mcreator.winterdropruined.potion.PufferNautilusDashCooldownMobEffect;
import net.mcreator.winterdropruined.potion.PufferNautilusDashEffectMobEffect;
import net.mcreator.winterdropruined.potion.PufferNautilusForwardEffectMobEffect;
import net.mcreator.winterdropruined.potion.PufferNautilusRiddingEffectMobEffect;
import net.mcreator.winterdropruined.potion.RangeBonusMobEffect;
import net.mcreator.winterdropruined.potion.TentacleRangeMobEffect;
import net.mcreator.winterdropruined.procedures.BonusHealthOverMaxHealthEffectExpiresProcedure;
import net.mcreator.winterdropruined.procedures.KrakentilusShellEffectEffectExpiresProcedure;
import net.mcreator.winterdropruined.procedures.PufferNautilusRiddingEffectEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class WinterDropRuinedModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"winter_drop_ruined");
    public static final DeferredHolder<MobEffect, MobEffect> RANGE_BONUS = REGISTRY.register("range_bonus", () -> new RangeBonusMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PUFFER_NAUTILUS_RIDDING_EFFECT = REGISTRY.register("puffer_nautilus_ridding_effect", () -> new PufferNautilusRiddingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PUFFER_NAUTILUS_DASH_COOLDOWN = REGISTRY.register("puffer_nautilus_dash_cooldown", () -> new PufferNautilusDashCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> KRAKENTILUS_SHELL_EFFECT = REGISTRY.register("krakentilus_shell_effect", () -> new KrakentilusShellEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PUFFER_NAUTILUS_FORWARD_EFFECT = REGISTRY.register("puffer_nautilus_forward_effect", () -> new PufferNautilusForwardEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PUFFER_NAUTILUS_BACKWARD_EFFECT = REGISTRY.register("puffer_nautilus_backward_effect", () -> new PufferNautilusBackwardEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PUFFER_NAUTILUS_DASH_EFFECT = REGISTRY.register("puffer_nautilus_dash_effect", () -> new PufferNautilusDashEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BONUS_HEALTH_OVER_MAX_HEALTH = REGISTRY.register("bonus_health_over_max_health", () -> new BonusHealthOverMaxHealthMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> KRAKENTILUS_BOSS_BAR_EFFECT = REGISTRY.register("krakentilus_boss_bar_effect", () -> new KrakentilusBossBarEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DROWNING_EFFECT = REGISTRY.register("drowning_effect", () -> new DrowningEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TENTACLE_RANGE = REGISTRY.register("tentacle_range", () -> new TentacleRangeMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            WinterDropRuinedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            WinterDropRuinedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(PUFFER_NAUTILUS_RIDDING_EFFECT)) {
            PufferNautilusRiddingEffectEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(KRAKENTILUS_SHELL_EFFECT)) {
            KrakentilusShellEffectEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(BONUS_HEALTH_OVER_MAX_HEALTH)) {
            BonusHealthOverMaxHealthEffectExpiresProcedure.execute(entity);
        }
    }
}

