/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.winterdropruined.network;

import net.mcreator.winterdropruined.WinterDropRuinedMod;
import net.mcreator.winterdropruined.procedures.PufferNautilusForwardOnKeyPressedProcedure;
import net.mcreator.winterdropruined.procedures.PufferNautilusForwardOnKeyReleasedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PufferNautilusForwardMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PufferNautilusForwardMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"winter_drop_ruined", (String)"key_puffer_nautilus_forward"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PufferNautilusForwardMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new PufferNautilusForwardMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<PufferNautilusForwardMessage> type() {
        return TYPE;
    }

    public static void handleData(PufferNautilusForwardMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> PufferNautilusForwardMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            PufferNautilusForwardOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            PufferNautilusForwardOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        WinterDropRuinedMod.addNetworkMessage(TYPE, STREAM_CODEC, PufferNautilusForwardMessage::handleData);
    }
}

