/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.shape_map;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;

public class ShapeMapFileHandler
extends class_4309<JsonElement> {
    public static final class_7654 CONVERTER = class_7654.method_45114((String)"shape_map");

    public ShapeMapFileHandler() {
        super(class_5699.field_40721, CONVERTER);
    }

    protected void apply(Map<class_2960, JsonElement> file, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, List<class_2960>> result = new HashMap<class_2960, List<class_2960>>();
        HashMap<String, ShapeMapFile> namespaceMap = new HashMap<String, ShapeMapFile>();
        for (Map.Entry<class_2960, JsonElement> fileEntry : file.entrySet()) {
            class_2960 fileName = fileEntry.getKey();
            String path = fileName.method_12832();
            if (!path.equals("add_shapes") && !path.equals("remove_shapes")) continue;
            HashMap fileShapeMap = new HashMap();
            JsonObject content = fileEntry.getValue().getAsJsonObject();
            for (Map.Entry contentEntry : content.entrySet()) {
                class_2960 key = ClutterNoMore.parse((String)contentEntry.getKey());
                ArrayList<class_2960> values = new ArrayList<class_2960>();
                for (JsonElement element : ((JsonElement)contentEntry.getValue()).getAsJsonArray()) {
                    values.add(ClutterNoMore.parse(element.getAsString()));
                }
                fileShapeMap.put(key, values);
            }
            String namespace = fileName.method_12836();
            ShapeMapFile namespaceShapeMap = namespaceMap.computeIfAbsent(namespace, s -> new ShapeMapFile(new HashMap<class_2960, List<class_2960>>(), new HashMap<class_2960, List<class_2960>>()));
            if (path.equals("add_shapes")) {
                namespaceShapeMap.addMap().putAll(fileShapeMap);
                continue;
            }
            namespaceShapeMap.removeMap().putAll(fileShapeMap);
        }
        for (ShapeMapFile shapeMapFile : namespaceMap.values()) {
            result.putAll(shapeMapFile.getResultingMap());
        }
        ShapeMap.set(result);
    }

    private record ShapeMapFile(Map<class_2960, List<class_2960>> addMap, Map<class_2960, List<class_2960>> removeMap) {
        public Map<class_2960, List<class_2960>> getResultingMap() {
            for (Map.Entry<class_2960, List<class_2960>> entry : new HashSet<Map.Entry<class_2960, List<class_2960>>>(this.removeMap.entrySet())) {
                class_2960 key = entry.getKey();
                List<class_2960> removeList = entry.getValue();
                List<class_2960> list = this.addMap.get(key);
                if (list == null || !list.removeAll(removeList) || !list.isEmpty()) continue;
                this.addMap.remove(key);
            }
            return this.addMap;
        }
    }
}

