/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.neoforge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.neoforge.NeoForgeClientEvents;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;

public class NeoForgePlatformImpl
implements Platform {
    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Override
    public String loader() {
        return "neoforge";
    }

    @Override
    public Path getResourcePack() {
        return FMLPaths.getOrCreateGameRelativePath((Path)Path.of("resourcepacks", new String[0]));
    }

    @Override
    public JsonObject getFileInJar(String namespace, String path) {
        try {
            return JsonParser.parseReader((Reader)new FileReader(ModLoadingContext.get().getActiveContainer().getModInfo().getOwningFile().getFile().findResource(new String[]{path}).toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    @Override
    public int shapeKey() {
        return ((KeyMapping)NeoForgeClientEvents.SHAPE_KEY.get()).getKey().getValue();
    }

    @Override
    public void finalizeCopperBlockRegistration() {
        JsonObject oxidizableMap = new JsonObject();
        JsonObject oxidizableValues = new JsonObject();
        ClutterNoMore.COPPER_BLOCKS.forEach((less, more) -> {
            JsonObject next_stage = new JsonObject();
            next_stage.addProperty("next_oxidation_stage", more.toString());
            oxidizableValues.add(less.toString(), (JsonElement)next_stage);
        });
        oxidizableMap.add("values", (JsonElement)oxidizableValues);
        DataGenerator.writeServerData(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"data_maps/block/oxidizables.json"), (JsonElement)oxidizableMap);
        JsonObject waxableMap = new JsonObject();
        JsonObject waxableValues = new JsonObject();
        ClutterNoMore.WAXED_COPPER_BLOCKS.forEach(waxedId -> {
            ResourceLocation unwaxedId = ClutterNoMore.location(waxedId.getNamespace(), waxedId.getPath().replace("waxed_", ""));
            JsonObject next_stage = new JsonObject();
            next_stage.addProperty("waxed", waxedId.toString());
            waxableValues.add(unwaxedId.toString(), (JsonElement)next_stage);
        });
        waxableMap.add("values", (JsonElement)waxableValues);
        DataGenerator.writeServerData(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"data_maps/block/waxables.json"), (JsonElement)waxableMap);
    }
}

