/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber
public class Configuration {
    public static final ModConfigSpec CONFIG_SPEC;
    private static final ModConfigSpec.BooleanValue DISABLE_WOOL;
    private static final ModConfigSpec.BooleanValue SHOW_TAB_BUTTONS;
    private static final ModConfigSpec.BooleanValue DEATH_RESET;
    public static final ModConfigSpec.BooleanValue HEALTH_BONUS;
    private static final ModConfigSpec.IntValue STARTING_COST;
    private static final ModConfigSpec.IntValue MAXIMUM_LEVEL;
    private static final ModConfigSpec.DoubleValue XP_SCALING_MULTIPLIER;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> SKILL_ALIAS;
    private static final ModConfigSpec.BooleanValue ENABLE_SKILL_LEVELING;
    private static final ModConfigSpec.BooleanValue ENABLE_SKILL_UP_MESSAGE;
    public static final ModConfigSpec.IntValue LEVELS_PER_HEART;
    public static final ModConfigSpec.DoubleValue HEALTH_PER_HEART;
    public static ModConfigSpec.DoubleValue ATTACK_DAMAGE_BONUS;
    public static ModConfigSpec.DoubleValue ARMOR_BONUS;
    public static ModConfigSpec.DoubleValue MOVEMENT_SPEED_BONUS;
    public static ModConfigSpec.DoubleValue LUCK_BONUS;
    public static ModConfigSpec.DoubleValue BLOCK_REACH_BONUS;
    public static ModConfigSpec.DoubleValue MINING_SPEED_MULTIPLIER;
    public static ModConfigSpec.DoubleValue CROP_GROWTH_CHANCE;
    public static final ModConfigSpec.DoubleValue GATHERING_XP_BONUS;
    public static final ModConfigSpec.ConfigValue<String> MAGIC_ATTRIBUTE_ID;
    private static boolean disableWool;
    private static boolean showTabButtons;
    private static boolean deathReset;
    private static boolean healthbonus;
    private static int startingCost;
    private static int maximumLevel;
    private static double xpScalingMultiplier;
    private static boolean enableSkillLeveling;
    private static Map<String, Requirement[]> skillLocks;
    private static Map<String, Requirement[]> craftSkillLocks;
    private static Map<String, Requirement[]> attackSkillLocks;
    private static final String DEFAULT_SKILL_LOCKS = "{\n  \"skillLocks\": {\n    \"minecraft:iron_sword\": [\"attack:5\"],\n    \"minecraft:iron_shovel\": [\"gathering:5\"],\n    \"minecraft:iron_pickaxe\": [\"mining:5\"],\n    \"minecraft:iron_axe\": [\"gathering:5\"],\n    \"minecraft:iron_hoe\": [\"farming:5\"],\n    \"minecraft:iron_helmet\": [\"defense:5\"],\n    \"minecraft:iron_chestplate\": [\"defense:5\"],\n    \"minecraft:iron_leggings\": [\"defense:5\"],\n    \"minecraft:iron_boots\": [\"defense:5\"],\n    \"minecraft:diamond_sword\": [\"attack:15\"],\n    \"minecraft:diamond_shovel\": [\"gathering:15\"],\n    \"minecraft:diamond_pickaxe\": [\"mining:15\"],\n    \"minecraft:diamond_axe\": [\"gathering:15\"],\n    \"minecraft:diamond_hoe\": [\"farming:15\"],\n    \"minecraft:diamond_helmet\": [\"defense:15\"],\n    \"minecraft:diamond_chestplate\": [\"defense:15\"],\n    \"minecraft:diamond_leggings\": [\"defense:15\"],\n    \"minecraft:diamond_boots\": [\"defense:15\"],\n    \"minecraft:netherite_sword\": [\"attack:30\"],\n    \"minecraft:netherite_shovel\": [\"gathering:30\"],\n    \"minecraft:netherite_pickaxe\": [\"mining:30\"],\n    \"minecraft:netherite_axe\": [\"gathering:30\"],\n    \"minecraft:netherite_hoe\": [\"farming:30\"],\n    \"minecraft:netherite_helmet\": [\"defense:30\"],\n    \"minecraft:netherite_chestplate\": [\"defense:30\"],\n    \"minecraft:netherite_leggings\": [\"defense:30\"],\n    \"minecraft:netherite_boots\": [\"defense:30\"]\n  }\n}\n";
    private static final String DEFAULT_CRAFT_SKILL_LOCKS = "{\n  \"craftSkillLocks\": {}\n}\n";
    private static final String DEFAULT_ATTACK_SKILL_LOCKS = "{\n  \"attackSkillLocks\": {\n    \"minecraft:zombie\": [\"attack:2\"],\n    \"minecraft:skeleton\": [\"attack:2\"]\n  }\n}\n";
    private static final Map<String, List<String>> RANGED_WEAPON_REQUIREMENTS;
    private static final Map<String, ArmorStats> VANILLA_ARMOR_BENCHMARKS;

    public static void load() {
        disableWool = (Boolean)DISABLE_WOOL.get();
        showTabButtons = (Boolean)SHOW_TAB_BUTTONS.get();
        deathReset = (Boolean)DEATH_RESET.get();
        startingCost = (Integer)STARTING_COST.get();
        healthbonus = (Boolean)HEALTH_BONUS.get();
        xpScalingMultiplier = (Double)XP_SCALING_MULTIPLIER.get();
        maximumLevel = (Integer)MAXIMUM_LEVEL.get();
        enableSkillLeveling = (Boolean)ENABLE_SKILL_LEVELING.get();
        Map<String, Map<String, List<String>>> skillData = Configuration.loadJsonConfig(FMLPaths.CONFIGDIR.get().resolve("reskillable/skill_locks.json").toString(), DEFAULT_SKILL_LOCKS, "skillLocks");
        Map<String, Map<String, List<String>>> craftData = Configuration.loadJsonConfig(FMLPaths.CONFIGDIR.get().resolve("reskillable/craft_skill_locks.json").toString(), DEFAULT_CRAFT_SKILL_LOCKS, "craftSkillLocks");
        Map<String, Map<String, List<String>>> attackData = Configuration.loadJsonConfig(FMLPaths.CONFIGDIR.get().resolve("reskillable/attack_skill_locks.json").toString(), DEFAULT_ATTACK_SKILL_LOCKS, "attackSkillLocks");
        skillLocks = Configuration.parseSkillLocks(skillData.get("skillLocks"));
        craftSkillLocks = Configuration.parseSkillLocks(craftData.get("craftSkillLocks"));
        attackSkillLocks = Configuration.parseSkillLocks(attackData.get("attackSkillLocks"));
    }

    public static boolean isSkillLevelingEnabled() {
        return enableSkillLeveling;
    }

    public static boolean isSkillUpMessageEnabled() {
        return (Boolean)ENABLE_SKILL_UP_MESSAGE.get();
    }

    public static Attribute getConfiguredMagicAttribute() {
        try {
            String fullPath = (String)MAGIC_ATTRIBUTE_ID.get();
            String[] splitPath = fullPath.split(":", 2);
            ResourceLocation id = splitPath.length == 2 ? ResourceLocation.fromNamespaceAndPath((String)splitPath[0], (String)splitPath[1]) : ResourceLocation.withDefaultNamespace((String)splitPath[0]);
            return (Attribute)BuiltInRegistries.ATTRIBUTE.get(id);
        }
        catch (Exception e) {
            System.err.println("[Reskillable] Invalid attribute ID in config for magicAttribute: " + (String)MAGIC_ATTRIBUTE_ID.get());
            return (Attribute)Attributes.LUCK;
        }
    }

    private static Map<String, Requirement[]> parseSkillLocks(Map<String, List<String>> data) {
        HashMap<String, Requirement[]> locks = new HashMap<String, Requirement[]>();
        if (data == null) {
            System.err.println("No data found for skill locks.");
            return locks;
        }
        for (Map.Entry<String, List<String>> entry : data.entrySet()) {
            try {
                List<String> rawRequirements = entry.getValue();
                Requirement[] requirements = new Requirement[rawRequirements.size()];
                for (int i = 0; i < rawRequirements.size(); ++i) {
                    String[] reqParts = rawRequirements.get(i).split(":");
                    if (reqParts.length != 2) {
                        System.err.println("Invalid requirement format: " + rawRequirements.get(i));
                        continue;
                    }
                    String skillName = reqParts[0].toUpperCase();
                    int level = Integer.parseInt(reqParts[1]);
                    requirements[i] = new Requirement(Skill.valueOf(skillName), level);
                }
                locks.put(entry.getKey(), requirements);
            }
            catch (Exception e) {
                System.err.println("Error parsing skill lock for key: " + entry.getKey());
                e.printStackTrace();
            }
        }
        return locks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Map<String, List<String>>> loadJsonConfig(String filename, String defaultContent, String expectedKey) {
        File file = new File(filename);
        if (!file.exists()) {
            if (Configuration.createDefaultJsonFile(file, defaultContent)) {
                System.out.println("Default file created: " + filename);
            } else {
                System.err.println("Failed to create default file: " + filename);
            }
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!jsonObject.has(expectedKey)) {
                System.err.println("Missing '" + expectedKey + "' key in JSON: " + filename);
                HashMap<String, Map<String, List<String>>> hashMap = new HashMap<String, Map<String, List<String>>>();
                return hashMap;
            }
            Type mapType = new TypeToken<Map<String, Map<String, List<String>>>>(){}.getType();
            Map map = (Map)new Gson().fromJson((JsonElement)jsonObject, mapType);
            return map;
        }
        catch (Exception e) {
            System.err.println("Error loading JSON from file: " + filename);
            e.printStackTrace();
            return new HashMap<String, Map<String, List<String>>>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean createDefaultJsonFile(File file, String content) {
        try {
            if (!file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
                System.err.println("Failed to create directories for file: " + file.getPath());
                return false;
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write(content);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean getDisableWool() {
        return disableWool;
    }

    public static boolean shouldShowTabButtons() {
        return showTabButtons;
    }

    public static boolean getDeathReset() {
        return deathReset;
    }

    public static double getXpScalingMultiplier() {
        return xpScalingMultiplier;
    }

    public static int calculateCostForLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Level must be 1 or greater");
        }
        int[] totalXpCosts = new int[]{7, 16, 27, 40, 55, 72, 91, 112, 135, 160, 187, 216, 247, 280, 315, 352, 394, 441, 493, 550, 612, 679, 751, 828, 910, 997, 1089, 1186, 1288, 1395, 1507, 1628, 1758, 1897, 2045, 2202, 2368, 2543, 2727, 2920, 3122, 3333, 3553, 3782, 4020, 4267, 4523, 4788, 5062, 5345};
        double multiplier = Configuration.getXpScalingMultiplier();
        if (level <= totalXpCosts.length) {
            return (int)Math.ceil((double)totalXpCosts[level - 1] * multiplier);
        }
        return (int)Math.ceil(300.0 * multiplier);
    }

    public static int getMaxLevel() {
        return maximumLevel;
    }

    public static Requirement[] getRequirements(ResourceLocation key) {
        return skillLocks.get(key.toString());
    }

    public static Requirement[] getCraftRequirements(ResourceLocation key) {
        return craftSkillLocks.get(key.toString());
    }

    public static Requirement[] getEntityAttackRequirements(ResourceLocation key) {
        return attackSkillLocks.get(key.toString());
    }

    public static ModConfigSpec getConfig() {
        return CONFIG_SPEC;
    }

    public static Map<String, Requirement[]> getSkillLocks() {
        return skillLocks;
    }

    public static void setSkillLocks(Map<String, Requirement[]> newSkillLocks) {
        if (skillLocks == null) {
            skillLocks = new HashMap<String, Requirement[]>();
        }
        skillLocks.putAll(newSkillLocks);
    }

    public static Map<String, Requirement[]> getCraftSkillLocks() {
        return craftSkillLocks;
    }

    public static void setCraftSkillLocks(Map<String, Requirement[]> newCraftSkillLocks) {
        craftSkillLocks = newCraftSkillLocks;
    }

    public static Map<String, Requirement[]> getAttackSkillLocks() {
        return attackSkillLocks;
    }

    public static void setAttackSkillLocks(Map<String, Requirement[]> newAttackSkillLocks) {
        attackSkillLocks = newAttackSkillLocks;
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        Configuration.load();
    }

    public static int calculateExperienceCost(int level) {
        int[] totalXpCosts = new int[]{7, 16, 27, 40, 55, 72, 91, 112, 135, 160, 187, 216, 247, 280, 315, 352, 394, 441, 493, 550, 612, 679, 751, 828, 910, 997, 1089, 1186, 1288, 1395, 1507, 1628, 1758, 1897, 2045, 2202, 2368, 2543, 2727, 2920, 3122, 3333, 3553, 3782, 4020, 4267, 4523, 4788, 5062, 5345};
        double multiplier = Configuration.getXpScalingMultiplier();
        if (level <= 1) {
            return (int)Math.ceil((double)totalXpCosts[0] * multiplier);
        }
        if (level <= totalXpCosts.length) {
            int baseCost = totalXpCosts[level - 1] - totalXpCosts[level - 2];
            return (int)Math.ceil((double)baseCost * multiplier);
        }
        return (int)Math.ceil(300.0 * multiplier);
    }

    public static int getCumulativeXpForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        double multiplier = Configuration.getXpScalingMultiplier();
        if (level <= 16) {
            return (int)Math.ceil((double)(level * (level + 1) / 2 * 2) + (double)(7 * level) * multiplier);
        }
        if (level <= 31) {
            return (int)Math.ceil((2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) * multiplier);
        }
        return (int)Math.ceil((4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) * multiplier);
    }

    public static int scanModItems(String modId) {
        HashMap<String, List<String>> newEntries = new HashMap<String, List<String>>();
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            Object defaultRequirement;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (id == null || !id.getNamespace().equals(modId) || (defaultRequirement = Configuration.getDefaultRequirement(item)).isEmpty()) continue;
            newEntries.put(id.toString(), (List<String>)defaultRequirement);
        }
        if (newEntries.isEmpty()) {
            return 0;
        }
        try {
            File file = FMLPaths.CONFIGDIR.get().resolve("reskillable/skill_locks.json").toFile();
            JsonObject skillLocksJson = new JsonObject();
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    skillLocksJson = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                }
            }
            JsonObject skillLocks = skillLocksJson.has("skillLocks") ? skillLocksJson.getAsJsonObject("skillLocks") : new JsonObject();
            for (Map.Entry entry : newEntries.entrySet()) {
                if (skillLocks.has((String)entry.getKey())) continue;
                skillLocks.add((String)entry.getKey(), new Gson().toJsonTree(entry.getValue()));
            }
            skillLocksJson.add("skillLocks", (JsonElement)skillLocks);
            try (FileWriter writer = new FileWriter(file);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)skillLocksJson, (Appendable)writer);
            }
            return newEntries.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static List<String> getDefaultRequirement(Item item) {
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            int defense = armor.getDefense();
            double toughness = armor.getToughness();
            int level = Configuration.determineArmorSkillLevel(defense, toughness);
            return List.of("defense:" + level);
        }
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            double attackDamage = sword.getDamage(new ItemStack((ItemLike)sword));
            return List.of("attack:" + Configuration.determineAttackLevel(attackDamage));
        }
        if (item instanceof PickaxeItem) {
            PickaxeItem pickaxe = (PickaxeItem)item;
            int harvestLevel = pickaxe.getTier().getEnchantmentValue();
            return List.of("mining:" + Configuration.determineHarvestLevel(harvestLevel));
        }
        if (item instanceof ShovelItem) {
            ShovelItem shovel = (ShovelItem)item;
            int harvestLevel = shovel.getTier().getEnchantmentValue();
            return List.of("gathering:" + Configuration.determineHarvestLevel(harvestLevel));
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            int harvestLevel = axe.getTier().getEnchantmentValue();
            return List.of("gathering:" + Configuration.determineHarvestLevel(harvestLevel));
        }
        if (item instanceof HoeItem) {
            HoeItem hoe = (HoeItem)item;
            int harvestLevel = hoe.getTier().getEnchantmentValue();
            return List.of("farming:" + Configuration.determineHarvestLevel(harvestLevel));
        }
        if (item instanceof BowItem || item instanceof CrossbowItem) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (itemId != null) {
                String itemKey = itemId.toString();
                return RANGED_WEAPON_REQUIREMENTS.getOrDefault(itemKey, List.of("agility:10", "defense:5"));
            }
        } else {
            if (item.getClass().getSimpleName().toLowerCase().contains("scythe")) {
                return List.of("attack:20", "defense:15");
            }
            if (item.getClass().getSimpleName().toLowerCase().contains("staff")) {
                return List.of("magic:25");
            }
        }
        return List.of();
    }

    private static int determineArmorSkillLevel(int defense, double toughness) {
        for (Map.Entry<String, ArmorStats> entry : VANILLA_ARMOR_BENCHMARKS.entrySet()) {
            ArmorStats benchmark = entry.getValue();
            if (defense > benchmark.totalDefense || !(toughness <= benchmark.toughness)) continue;
            return switch (entry.getKey()) {
                case "leather" -> 5;
                case "chainmail" -> 10;
                case "iron" -> 15;
                case "gold" -> 15;
                case "diamond" -> 20;
                case "netherite" -> 30;
                default -> 5;
            };
        }
        return 35;
    }

    private static int determineAttackLevel(double attackDamage) {
        if (attackDamage < 6.0) {
            return 5;
        }
        if (attackDamage < 10.0) {
            return 15;
        }
        return 30;
    }

    private static int determineHarvestLevel(int harvestLevel) {
        if (harvestLevel < 2) {
            return 5;
        }
        if (harvestLevel == 2) {
            return 15;
        }
        return 30;
    }

    static {
        skillLocks = new HashMap<String, Requirement[]>();
        craftSkillLocks = new HashMap<String, Requirement[]>();
        attackSkillLocks = new HashMap<String, Requirement[]>();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Disable wool drops to force the player to get shears.");
        DISABLE_WOOL = builder.define("disableWoolDrops", true);
        builder.comment("Reset all skills to 1 when a player dies.");
        DEATH_RESET = builder.define("deathSkillReset", false);
        builder.comment("Should you gain health on set level ups?");
        HEALTH_BONUS = builder.define("HealthBonus", true);
        builder.comment("Toggle the visibility of the tab buttons in the inventory.");
        SHOW_TAB_BUTTONS = builder.define("showTabButtons", true);
        builder.comment("Starting cost of upgrading to level 2, in experience points.");
        STARTING_COST = builder.defineInRange("startingCost", 7, 0, 1000);
        builder.comment("Global scaling multiplier for XP costs.");
        XP_SCALING_MULTIPLIER = builder.defineInRange("xpScalingMultiplier", 1.0, 0.1, 10.0);
        builder.comment("Maximum level each skill can be upgraded to.");
        MAXIMUM_LEVEL = builder.defineInRange("maximumLevel", 32, 2, 100);
        builder.comment(new String[]{"List of substitutions to perform in names in skill lock lists.", "Useful if you're using a resource pack to change the names of skills, this config doesn't affect gameplay, just accepted values in other configs so it's easier to think about", "Format: key=value", "Valid values: attack, defense, mining, gathering, farming, building, agility, magic"});
        ENABLE_SKILL_LEVELING = builder.comment("Enable or disable skill leveling via GUI or selection. If disabled, skill levels must be granted by commands.").define("enableSkillLeveling", true);
        ENABLE_SKILL_UP_MESSAGE = builder.comment("Enable or disable the skill level-up message.").define("enableSkillUpMessage", true);
        SKILL_ALIAS = builder.defineList("skillAliases", List.of("defense=defense"), obj -> true);
        ATTACK_DAMAGE_BONUS = builder.defineInRange("attackDamageBonus", 0.15, 0.0, 10.0);
        ARMOR_BONUS = builder.defineInRange("armorBonus", 0.15, 0.0, 10.0);
        MOVEMENT_SPEED_BONUS = builder.defineInRange("movementSpeedBonus", 0.05, 0.0, 1.0);
        MAGIC_ATTRIBUTE_ID = builder.comment("The registry ID of the attribute to use for the Magic skill (e.g. 'modid:spell_power')").define("magicAttribute", (Object)"minecraft:generic.luck");
        LUCK_BONUS = builder.defineInRange("MagicBonus", 0.05, 0.0, 10.0);
        BLOCK_REACH_BONUS = builder.defineInRange("blockReachBonus", 0.25, 0.0, 5.0);
        MINING_SPEED_MULTIPLIER = builder.defineInRange("miningSpeedMultiplier", 0.25, 0.0, 5.0);
        CROP_GROWTH_CHANCE = builder.defineInRange("cropGrowthChancePer5Levels", 0.25, 0.0, 1.0);
        GATHERING_XP_BONUS = builder.comment("Bonus XP multiplier per 5 levels of Gathering (e.g., 0.05 = +5% XP per step)").defineInRange("gatheringXpBonus", 0.05, 0.0, 1.0);
        LEVELS_PER_HEART = builder.comment("How many total skill levels are required for each heart gained.").defineInRange("levelsPerHeart", 10, 1, 100);
        HEALTH_PER_HEART = builder.comment("How much health (in half-hearts) is granted per configured levelsPerHeart.").defineInRange("healthPerHeart", 2.0, 0.5, 20.0);
        CONFIG_SPEC = builder.build();
        RANGED_WEAPON_REQUIREMENTS = Map.of("minecraft:bow", List.of("agility:10", "defense:5"), "minecraft:crossbow", List.of("agility:10", "defense:5"), "modid:longbow", List.of("agility:15", "defense:10"), "modid:netherite_crossbow", List.of("agility:30", "defense:25"));
        VANILLA_ARMOR_BENCHMARKS = Map.of("leather", new ArmorStats(3, 0.0), "chainmail", new ArmorStats(12, 0.0), "iron", new ArmorStats(15, 0.0), "gold", new ArmorStats(11, 0.0), "diamond", new ArmorStats(20, 2.0), "netherite", new ArmorStats(20, 3.0));
    }

    private static class ArmorStats {
        int totalDefense;
        double toughness;

        public ArmorStats(int totalDefense, double toughness) {
            this.totalDefense = totalDefense;
            this.toughness = toughness;
        }
    }
}

