/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.logging.Logger;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.server.command.EnumArgument;

@EventBusSubscriber
public class GetCommand {
    private static final Logger LOGGER = Logger.getLogger(GetCommand.class.getName());

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).executes(GetCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int level = SkillModel.get((Player)player).getSkillLevel(skill);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)skill.displayName).append(" " + level), true);
        return level;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"skills").then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).executes(GetCommand::execute)))));
    }
}

