/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.Overlay;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.network.payload.NotifyWarning;
import net.bandit.reskillable.common.network.payload.SyncSkillConfig;
import net.bandit.reskillable.common.network.payload.SyncToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ClientHandlers {
    public static void handleSyncToClient(SyncToClient msg) {
        SkillModel clientSkillModel;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (clientSkillModel = SkillModel.get((Player)player)) != null) {
            clientSkillModel.readFromNetwork(msg);
        }
    }

    public static void handleNotifyWarning(NotifyWarning msg) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Overlay.showWarning(msg.resource(), msg.requirementType());
        }
    }

    public static void handleSyncSkillConfig(SyncSkillConfig msg) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Configuration.setSkillLocks(msg.skillLocks());
            Configuration.setCraftSkillLocks(msg.craftSkillLocks());
            Configuration.setAttackSkillLocks(msg.attackSkillLocks());
            if (msg.isFinalChunk()) {
                player.sendSystemMessage((Component)Component.literal((String)"Skill configuration updated!"));
            }
        }
    }
}

