/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network.payload;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncSkillConfig(Map<String, Requirement[]> skillLocks, Map<String, Requirement[]> craftSkillLocks, Map<String, Requirement[]> attackSkillLocks, boolean isFinalChunk) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"sync_config");
    public static final CustomPacketPayload.Type<SyncSkillConfig> TYPE = new CustomPacketPayload.Type(ID);
    private static final Logger LOGGER = Logger.getLogger(SyncSkillConfig.class.getName());
    private static final Gson GSON = new Gson();
    private static final Type REQ_MAP_TYPE = new TypeToken<Map<String, Requirement[]>>(){}.getType();
    public static final StreamCodec<FriendlyByteBuf, SyncSkillConfig> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        try {
            buf.writeByteArray(SyncSkillConfig.compress(GSON.toJson(msg.skillLocks)));
            buf.writeByteArray(SyncSkillConfig.compress(GSON.toJson(msg.craftSkillLocks)));
            buf.writeByteArray(SyncSkillConfig.compress(GSON.toJson(msg.attackSkillLocks)));
            buf.writeBoolean(msg.isFinalChunk);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compress SyncSkillConfig", e);
        }
    }, buf -> {
        try {
            Map skillLocks = (Map)GSON.fromJson(SyncSkillConfig.decompress(buf.readByteArray()), REQ_MAP_TYPE);
            Map craftLocks = (Map)GSON.fromJson(SyncSkillConfig.decompress(buf.readByteArray()), REQ_MAP_TYPE);
            Map attackLocks = (Map)GSON.fromJson(SyncSkillConfig.decompress(buf.readByteArray()), REQ_MAP_TYPE);
            boolean isFinal = buf.readBoolean();
            return new SyncSkillConfig(skillLocks, craftLocks, attackLocks, isFinal);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress SyncSkillConfig", e);
        }
    });

    private static byte[] compress(String data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(data.getBytes());
        }
        return out.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private static String decompress(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

