/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class KelpGolem
extends BaseGolem {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private static final EntityDataAccessor<Boolean> ID_CHARGED = SynchedEntityData.defineId(KelpGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public KelpGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 14;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new KelpGolemMoveControl();
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.085).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)((RecipeHolder)level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (RecipeInput)new SingleEntityInput((EntityType)ModEntityTypes.KELP_GOLEM.get()), level).orElseThrow()).value();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().find((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        KelpGolem golem = (KelpGolem)((EntityType)ModEntityTypes.KELP_GOLEM.get()).create(level);
        if (golem == null) {
            return;
        }
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.getBlock(1, 2, 0).getPos());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.getMovementController());
        controllers.add(new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "spin_controller", 0, state -> {
            if (!this.isCharged()) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.SPIN);
        }));
    }

    @Override
    public AnimationController<?> getMovementController() {
        return super.getMovementController().setSoundKeyframeHandler(event -> this.level().playLocalSound(this.blockPosition(), (SoundEvent)ModSoundEvents.KELP_GOLEM_STEP.get(), this.getSoundSource(), 1.0f, 1.0f, false));
    }

    @Override
    public PlayState handleMovementController(AnimationState<BaseGolem> state) {
        boolean moving;
        boolean bl = moving = (double)state.getLimbSwingAmount() > 0.05 || (double)state.getLimbSwingAmount() < -0.05;
        if (this.isInWater()) {
            state.getController().setAnimation(ConstantAnimations.SWIM);
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(moving ? ConstantAnimations.WALK : (this.isInWater() ? ConstantAnimations.IDLE_WATER : ConstantAnimations.IDLE));
        return PlayState.CONTINUE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_CHARGED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Charged", this.isCharged());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCharged(compound.getBoolean("Charged"));
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 3, true, false, this::shouldAttack));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isCharged() {
        return (Boolean)this.entityData.get(ID_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.entityData.set(ID_CHARGED, (Object)charged);
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.KELP_GOLEM_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public boolean canFloatInWater() {
        return false;
    }

    @Override
    public Item getRepairItem() {
        return Items.KELP;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return (SoundEvent)ModSoundEvents.KELP_GOLEM_STEP.get();
    }

    @Override
    public int getAttackTicks() {
        return 18;
    }

    @Override
    public int getAttackDelayTicks() {
        return 6;
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public void baseTick() {
        int airSupply = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(airSupply);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.tickCount % 60 == 0) {
            if (this.inConduitRange()) {
                this.setCharged(true);
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1, true, true));
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0, true, true));
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 1, true, true));
            } else {
                this.setCharged(false);
            }
        }
    }

    private boolean inConduitRange() {
        return this.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(0.01f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public void updateSwimming() {
        if (!this.level().isClientSide()) {
            if (this.isEffectiveAi() && this.level().getBlockState(this.blockPosition().above(2)).is(Blocks.WATER)) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
        super.updateSwimming();
    }

    protected void handleAirSupply(int airSupply) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(airSupply - 1);
            if (this.getAirSupply() == -200) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(2.0, 0.0, 2.0);
    }

    private class KelpGolemMoveControl
    extends MoveControl {
        KelpGolemMoveControl() {
            super((Mob)KelpGolem.this);
        }

        public void tick() {
            if (!KelpGolem.this.isInWater()) {
                super.tick();
                return;
            }
            LivingEntity livingEntity = KelpGolem.this.getTarget();
            if (livingEntity != null && livingEntity.getY() > KelpGolem.this.getY()) {
                KelpGolem.this.setDeltaMovement(KelpGolem.this.getDeltaMovement().add(0.0, 0.002, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || KelpGolem.this.getNavigation().isDone()) {
                KelpGolem.this.setSpeed(0.0f);
                return;
            }
            double x = this.wantedX - KelpGolem.this.getX();
            double y = this.wantedY - KelpGolem.this.getY();
            double z = this.wantedZ - KelpGolem.this.getZ();
            double distance = Math.sqrt(x * x + y * y + z * z);
            y /= distance;
            float h = (float)(Mth.atan2((double)z, (double)x) * 57.3) - 90.0f;
            KelpGolem.this.setYRot(this.rotlerp(KelpGolem.this.getYRot(), h, 90.0f));
            KelpGolem.this.yBodyRot = KelpGolem.this.getYRot();
            float speed = (float)(this.speedModifier * KelpGolem.this.getAttributeValue(Attributes.MOVEMENT_SPEED));
            speed = Mth.lerp((float)0.125f, (float)KelpGolem.this.getSpeed(), (float)speed);
            KelpGolem.this.setSpeed(speed);
            KelpGolem.this.setDeltaMovement(KelpGolem.this.getDeltaMovement().add((double)(speed *= 20.0f) * x * 0.005, (double)speed * y * 0.025, (double)speed * z * 0.005));
        }
    }
}

