/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;

public abstract class BaseGolem
extends AbstractGolem
implements GeoEntity {
    public static final byte ATTACK_EVENT_ID = 4;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, true);
    private final HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[]{BaseGolem.class});
    private final NearestAttackableTargetGoal<Mob> attackTargetGoal = new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, false, this::shouldAttack);
    protected int attackAnimationTicks;
    protected int attackDelayTicks = -1;

    protected BaseGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.updateAttackGoals();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.getMovementController());
        controllers.add(new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        }));
    }

    public AnimationController<?> getMovementController() {
        return new AnimationController((GeoAnimatable)this, this::handleMovementController);
    }

    public PlayState handleMovementController(AnimationState<BaseGolem> state) {
        boolean moving = (double)state.getLimbSwingAmount() > 0.05 || (double)state.getLimbSwingAmount() < -0.05;
        return this.getMoveAnimation(state, moving);
    }

    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        return state.setAndContinue(moving ? ConstantAnimations.WALK : ConstantAnimations.IDLE);
    }

    public PlayState getAttackAnimation(AnimationState<? extends BaseGolem> state) {
        return state.setAndContinue(ConstantAnimations.ATTACK);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void registerGoals() {
        if (this.canFloatInWater()) {
            this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        }
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public final void updateAttackGoals() {
        this.goalSelector.removeGoal((Goal)this.meleeAttackGoal);
        this.targetSelector.removeGoal((Goal)this.hurtByTargetGoal);
        this.targetSelector.removeGoal(this.attackTargetGoal);
        if (this.canMeleeAttack()) {
            this.goalSelector.addGoal(1, (Goal)this.meleeAttackGoal);
        }
        if (this.canTarget()) {
            this.targetSelector.addGoal(2, (Goal)this.hurtByTargetGoal);
            this.targetSelector.addGoal(3, this.attackTargetGoal);
        }
    }

    public boolean canMeleeAttack() {
        return this.canTarget();
    }

    public boolean canTarget() {
        return true;
    }

    public boolean shouldAttack(LivingEntity entity) {
        return entity instanceof Enemy && !(entity instanceof Creeper);
    }

    public Crackiness.Level getCrackiness() {
        float fraction = this.getHealth() / this.getMaxHealth();
        if ((double)fraction > 0.66) {
            return Crackiness.Level.NONE;
        }
        if ((double)fraction > 0.33) {
            return Crackiness.Level.MEDIUM;
        }
        return Crackiness.Level.HIGH;
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (this.isAttacking()) {
            return false;
        }
        this.startAttacking();
        this.sendAttackEvent();
        return this.hasDelayedAttack() || super.doHurtTarget(target);
    }

    public void startAttacking() {
        if (this.isAttacking()) {
            return;
        }
        this.attackAnimationTicks = this.getAttackTicks();
        if (this.hasDelayedAttack()) {
            this.attackDelayTicks = this.getAttackDelayTicks();
        }
    }

    public boolean isAttacking() {
        return this.attackAnimationTicks > 0 || this.attackDelayTicks > 0;
    }

    public void sendAttackEvent() {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 4) {
            this.startAttacking();
        }
    }

    private void tickAttackDelay() {
        LivingEntity target = this.getTarget();
        if (this.attackDelayTicks == 0) {
            if (target != null && this.isWithinMeleeAttackRange(target)) {
                this.actuallyAttackAfterDelay(target);
            }
            this.performAdditionalAttacks(target);
            this.attackDelayTicks = -1;
        }
    }

    public void actuallyAttackAfterDelay(LivingEntity target) {
        super.doHurtTarget((Entity)target);
    }

    public void performAdditionalAttacks(LivingEntity target) {
    }

    public boolean canFloatInWater() {
        return true;
    }

    public boolean hasAttackAnimation() {
        return true;
    }

    public int getAttackTicks() {
        return 0;
    }

    public int getAttackDelayTicks() {
        return 0;
    }

    public final boolean hasDelayedAttack() {
        return this.getAttackDelayTicks() > 0;
    }

    public Item getRepairItem() {
        return Items.AIR;
    }

    public abstract float getRepairItemHealAmount();

    public boolean canRepair(ItemStack stack) {
        return stack.is(this.getRepairItem());
    }

    public SoundEvent getRepairSound() {
        return SoundEvents.IRON_GOLEM_REPAIR;
    }

    public final void removeAndAddDeathParticles() {
        this.level().broadcastEntityEvent((Entity)this, (byte)60);
        this.remove(Entity.RemovalReason.KILLED);
    }

    public void aiStep() {
        super.aiStep();
        this.attackAnimationTicks = Math.max(0, this.attackAnimationTicks - 1);
        this.attackDelayTicks = Math.max(-1, this.attackDelayTicks - 1);
        if (this.hasDelayedAttack()) {
            this.tickAttackDelay();
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.canRepair(stack)) {
            return InteractionResult.PASS;
        }
        float health = this.getHealth();
        this.heal(this.getRepairItemHealAmount());
        if (this.getHealth() == health) {
            return InteractionResult.PASS;
        }
        float pitch = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
        this.playSound(this.getRepairSound(), 1.0f, pitch);
        stack.consume(1, (LivingEntity)player);
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.updateAttackGoals();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.updateAttackGoals();
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GENERIC_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }
}

