/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.IShearable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class HayGolem
extends BaseGolem
implements IShearable {
    private static final EntityDataAccessor<Byte> ID_COLOR = SynchedEntityData.m_135353_(HayGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_SHEARED = SynchedEntityData.m_135353_(HayGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HayGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 8;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22281_, 3.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnHayGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (Container)new SingleEntityInput((EntityType)ModEntityTypes.HAY_GOLEM.get()), level).orElseThrow();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().m_61184_((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        HayGolem golem = (HayGolem)((EntityType)ModEntityTypes.HAY_GOLEM.get()).m_20615_(level);
        if (golem == null) {
            return;
        }
        golem.setColor(level.m_213780_().m_188499_() ? Color.GREEN : Color.RED);
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.m_61229_(1, 2, 0).m_61176_());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_COLOR, (Object)0);
        this.f_19804_.m_135372_(ID_SHEARED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("color", this.getColor().name().toLowerCase(Locale.ROOT));
        compound.m_128379_("sheared", this.isSheared());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("color")) {
            this.setColor(Color.valueOf(compound.m_128461_("color").toUpperCase(Locale.ROOT)));
        }
        this.setSheared(compound.m_128471_("sheared"));
    }

    @Override
    public boolean canTarget() {
        return false;
    }

    public Color getColor() {
        return Color.values()[(Byte)this.f_19804_.m_135370_(ID_COLOR)];
    }

    public void setColor(Color color) {
        this.f_19804_.m_135381_(ID_COLOR, (Object)((byte)color.ordinal()));
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(ID_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(ID_SHEARED, (Object)sheared);
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.HAY_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.HAY_GOLEM_DEATH.get();
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42405_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 10.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_144238_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setColor(level.m_213780_().m_188499_() ? Color.GREEN : Color.RED);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(0.5, 0.0, 0.5);
    }

    @NotNull
    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)0.3f, 0.0);
    }

    @Override
    @NotNull
    public List<ItemStack> onSheared() {
        this.m_216990_(SoundEvents.f_12480_);
        this.setSheared(true);
        return List.of(Items.f_42047_.m_7968_());
    }

    @Override
    public boolean isShearable() {
        return !this.isSheared();
    }

    public static enum Color {
        GREEN,
        RED;

    }
}

