/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.AdditionalBeeData;
import tech.alexnijjar.golemoverhaul.common.entities.IShearable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.HoneyBlobProjectile;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;
import tech.alexnijjar.golemoverhaul.mixins.common.BeeAccessor;

public class HoneyGolem
extends BaseGolem
implements RangedAttackMob,
IShearable {
    public static final byte NECTAR_PARTICLES_EVENT_ID = 8;
    public static final int RANGED_ATTACK_DELAY_TICKS = 6;
    public static final EntityDataAccessor<Byte> ID_HONEY_LEVEL = SynchedEntityData.m_135353_(HoneyGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final List<BeeData> bees = new ArrayList<BeeData>();
    private int attackAnimationDelay = -1;
    private boolean hasPopulatedInitialBees;

    public HoneyGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 8;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 6.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnHoneyGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_HONEY_LEVEL, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("HoneyLevel", this.getHoneyLevel());
        ListTag beeTag = new ListTag();
        for (BeeData bee : this.bees) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("EntityData", (Tag)bee.tag);
            tag.m_128405_("TicksInHive", bee.ticks);
            tag.m_128405_("MinOccupationTicks", bee.minOccupationTicks);
            beeTag.add((Object)tag);
        }
        compound.m_128365_("Bees", (Tag)beeTag);
        compound.m_128379_("HasPopulatedInitialBees", this.hasPopulatedInitialBees);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHoneyLevel(compound.m_128445_("HoneyLevel"));
        ListTag beeTag = compound.m_128437_("Bees", 10);
        for (int i = 0; i < beeTag.size(); ++i) {
            CompoundTag tag = beeTag.m_128728_(i);
            this.bees.add(new BeeData(tag.m_128469_("EntityData"), tag.m_128451_("TicksInHive"), tag.m_128451_("MinOccupationTicks")));
        }
        this.hasPopulatedInitialBees = compound.m_128471_("HasPopulatedInitialBees");
    }

    @Override
    public boolean canMeleeAttack() {
        return false;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f));
    }

    public byte getHoneyLevel() {
        return (Byte)this.f_19804_.m_135370_(ID_HONEY_LEVEL);
    }

    public void setHoneyLevel(byte honeyLevel) {
        this.f_19804_.m_135381_(ID_HONEY_LEVEL, (Object)honeyLevel);
    }

    public boolean isFullOfHoney() {
        return this.getHoneyLevel() >= 4;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11966_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11964_;
    }

    @Override
    public int getAttackTicks() {
        return 15;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42787_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 20.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_11964_;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        if (this.attackAnimationDelay == -1) {
            this.sendAttackEvent();
            this.attackAnimationDelay = 6;
        }
    }

    public void actuallyShoot(LivingEntity target) {
        if (target == null) {
            return;
        }
        HoneyBlobProjectile projectile = new HoneyBlobProjectile(this.m_9236_(), (LivingEntity)this);
        projectile.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20186_() - projectile.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.m_6686_(x, y + distance + 0.8, z, 1.2f, 3.0f);
        this.m_9236_().m_7967_((Entity)projectile);
        this.m_5496_(SoundEvents.f_12384_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !this.hasPopulatedInitialBees) {
            this.hasPopulatedInitialBees = true;
            this.populateInitialBees();
        }
    }

    private void populateInitialBees() {
        int count = 2 + this.m_9236_().m_213780_().m_188503_(4);
        for (int i = 0; i < count; ++i) {
            Bee bee = Objects.requireNonNull((Bee)EntityType.f_20550_.m_20615_(this.m_9236_()));
            ((AdditionalBeeData)bee).golemoverhaul$setOwner(this.m_20148_());
            this.bees.add(new BeeData(bee.m_20240_(new CompoundTag()), 0, 2400));
        }
        this.setHoneyLevel((byte)count);
    }

    protected void m_8024_() {
        if (!this.bees.isEmpty() && this.m_9236_().m_213780_().m_188500_() < 0.005) {
            this.m_216990_(SoundEvents.f_11698_);
        }
        if (!this.m_9236_().m_46462_() && !this.m_9236_().m_46471_()) {
            for (int i = 0; i < this.bees.size(); ++i) {
                BeeData bee = this.bees.get(i);
                ++bee.ticks;
                if (bee.ticks < bee.minOccupationTicks) continue;
                this.releaseBee(i);
                --i;
            }
        }
        if (!this.bees.isEmpty() && this.f_19797_ % 200 == 0) {
            this.m_5634_(1.0f);
        }
        this.attackAnimationDelay = Math.max(-1, this.attackAnimationDelay - 1);
        if (this.attackAnimationDelay == 0) {
            this.actuallyShoot(this.m_5448_());
            this.attackAnimationDelay = -1;
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.bees.isEmpty()) {
            this.releaseAllBees();
        }
    }

    @Override
    @NotNull
    public List<ItemStack> onSheared() {
        if (!this.isFullOfHoney()) {
            return List.of();
        }
        this.m_216990_(SoundEvents.f_11697_);
        if (!this.m_9236_().m_5776_()) {
            this.setHoneyLevel((byte)0);
        }
        return List.of(new ItemStack((ItemLike)ModItems.HONEY_BLOB.get(), 5 + this.m_9236_().f_46441_.m_188503_(8)), new ItemStack((ItemLike)Items.f_42784_, 3));
    }

    @Override
    public boolean isShearable() {
        return this.isFullOfHoney();
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 8) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123782_, this.m_20185_() + this.m_217043_().m_188583_() * 0.25, this.m_20186_() + 0.5, this.m_20189_() + this.m_217043_().m_188583_() * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public void healFromNectar() {
        this.m_5634_(5.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)8);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (!this.bees.isEmpty() && (entity = source.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2 instanceof Player && (player = (Player)entity2).m_7500_()) {
                return super.m_6469_(source, amount);
            }
            this.releaseAllBees().forEach(bee -> bee.m_6710_(entity2));
        }
        return super.m_6469_(source, amount);
    }

    public boolean canPutBee() {
        return this.bees.size() < 5;
    }

    public void putBee(Bee bee) {
        if (!this.canPutBee()) {
            return;
        }
        ((AdditionalBeeData)bee).golemoverhaul$setOwner(this.m_20148_());
        this.bees.add(new BeeData(bee.m_20240_(new CompoundTag()), 0, 2400));
        if (bee.m_27856_() && !this.isFullOfHoney()) {
            this.setHoneyLevel((byte)(this.getHoneyLevel() + 1));
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(10.0f);
                this.m_9236_().m_7605_((Entity)this, (byte)8);
            }
        }
        bee.m_27864_();
        bee.m_146870_();
        this.m_216990_(SoundEvents.f_11695_);
    }

    private Bee releaseBee(int index) {
        BeeData data = this.bees.get(index);
        Bee bee = Objects.requireNonNull((Bee)EntityType.f_20550_.m_20615_(this.m_9236_()));
        bee.m_20258_(data.tag);
        bee.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        bee.m_27864_();
        bee.m_21153_(bee.m_21233_());
        this.m_9236_().m_7967_((Entity)bee);
        bee.m_27915_(400);
        this.m_216990_(SoundEvents.f_11696_);
        this.bees.remove(index);
        return bee;
    }

    public List<Bee> releaseAllBees() {
        ArrayList<Bee> removedBees = new ArrayList<Bee>();
        int size = this.bees.size();
        for (int i = 0; i < size; ++i) {
            Bee bee = this.releaseBee(0);
            ((BeeAccessor)bee).setRemainingCooldownBeforeLocatingNewFlower(400);
            removedBees.add(bee);
        }
        return removedBees;
    }

    private static final class BeeData {
        private final CompoundTag tag;
        private int ticks;
        private final int minOccupationTicks;

        private BeeData(CompoundTag tag, int ticks, int minOccupationTicks) {
            this.tag = tag;
            this.ticks = ticks;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

