/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aesthetictables.block.custom.CoffeeTable;
import net.alminoris.aesthetictables.block.custom.ExtraTable;
import net.alminoris.aesthetictables.block.custom.GardenTable;
import net.alminoris.aesthetictables.block.custom.SingleTable;
import net.alminoris.aesthetictables.block.custom.Table;
import net.alminoris.aesthetictables.item.ModItems;
import net.alminoris.aesthetictables.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aesthetictables");
    public static final Dictionary<String, RegistryObject<Block>> TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("table_" + name, () -> new Table(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion())));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> COFFEE_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("coffee_table_" + name, () -> new CoffeeTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion())));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> GARDEN_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("garden_table_" + name, () -> new GardenTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> DESK_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("desk_table_" + name, () -> new GardenTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> OCTAGONAL_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("octagonal_table_" + name, () -> new SingleTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> DINING_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("dining_table_" + name, () -> new ExtraTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> KITCHEN_TABLES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("kitchen_table_" + name, () -> new Table(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

