/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block.custom;

import java.util.ArrayList;
import net.alminoris.aesthetictables.block.custom.YAxisRotatedBlock;
import net.alminoris.aesthetictables.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GardenTable
extends YAxisRotatedBlock {
    protected static final VoxelShape TABLE_TOP = YAxisRotatedBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_FRONT = YAxisRotatedBlock.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0);
    protected static final VoxelShape LEG_BACK = YAxisRotatedBlock.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);

    public GardenTable(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Variant variant = (Variant)((Object)state.getValue(VARIANT));
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch (variant.ordinal()) {
            case 0: {
                boxes.add(TABLE_TOP.bounds());
                boxes.add(LEG_FRONT.bounds());
                boxes.add(LEG_BACK.bounds());
                break;
            }
            case 1: {
                boxes.add(TABLE_TOP.bounds());
                break;
            }
            case 2: {
                boxes.add(TABLE_TOP.bounds());
                boxes.add(LEG_FRONT.bounds());
                break;
            }
            case 3: {
                boxes.add(TABLE_TOP.bounds());
                boxes.add(LEG_BACK.bounds());
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateGardenTableVariant(state, world, pos);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        this.updateSurroundingGardenTablees(world, pos);
    }

    private void updateSurroundingGardenTablees(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.offset(direction.getNormal());
            BlockState neighborState = world.getBlockState(neighborPos);
            if (neighborState.getBlock() != this) continue;
            world.setBlock(neighborPos, this.updateGardenTableVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateGardenTableVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal());
        BlockPos rightPos = pos.offset(facing.getClockWise(Direction.Axis.Y).getNormal());
        boolean leftConnected = this.isGardenTable(world, leftPos, facing);
        boolean rightConnected = this.isGardenTable(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isGardenTable(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

