/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block.custom;

import java.util.ArrayList;
import net.alminoris.aesthetictables.block.custom.YAxisRotatedBlock;
import net.alminoris.aesthetictables.util.helper.VoxelShapeHelper;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class GardenTable
extends YAxisRotatedBlock {
    protected static final class_265 TABLE_TOP = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 LEG_FRONT = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0);
    protected static final class_265 LEG_BACK = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);

    public GardenTable(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, WATERLOGGED});
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        boolean waterlogged = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8036().method_5735())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    private class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        Variant variant = (Variant)((Object)state.method_11654(VARIANT));
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        switch (variant.ordinal()) {
            case 0: {
                boxes.add(TABLE_TOP.method_1107());
                boxes.add(LEG_FRONT.method_1107());
                boxes.add(LEG_BACK.method_1107());
                break;
            }
            case 1: {
                boxes.add(TABLE_TOP.method_1107());
                break;
            }
            case 2: {
                boxes.add(TABLE_TOP.method_1107());
                boxes.add(LEG_FRONT.method_1107());
                break;
            }
            case 3: {
                boxes.add(TABLE_TOP.method_1107());
                boxes.add(LEG_BACK.method_1107());
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return this.updateGardenTableVariant(state, world, pos);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingGardenTablees(world, pos);
    }

    private void updateSurroundingGardenTablees(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_26204() != this) continue;
            world.method_8501(neighborPos, this.updateGardenTableVariant(neighborState, (class_1936)world, neighborPos));
        }
    }

    private class_2680 updateGardenTableVariant(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        boolean leftConnected = this.isGardenTable(world, leftPos, facing);
        boolean rightConnected = this.isGardenTable(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isGardenTable(class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && state.method_11654((class_2769)FACING) == facing;
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

