/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage;

import com.king_tajin.block_explosion_damage.BlockDamageData;
import com.king_tajin.block_explosion_damage.BlockDamageManager;
import com.king_tajin.block_explosion_damage.config.ModConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExplosionHandler {
    public static void handleExplosion(ServerLevel level, Explosion explosion, List<BlockPos> affectedBlocks) {
        Vec3 explosionCenter = explosion.center();
        float radius = explosion.radius();
        BlockPos explosionPos = BlockPos.containing((double)explosionCenter.x, (double)explosionCenter.y, (double)explosionCenter.z);
        if (!level.getFluidState(explosionPos).isEmpty()) {
            affectedBlocks.clear();
            return;
        }
        Set<BlockPos> blocksToBreak = ExplosionHandler.processExplosionRadius(level, explosionCenter, radius);
        ExplosionHandler.updateAffectedBlocksList(affectedBlocks, blocksToBreak);
    }

    private static Set<BlockPos> processExplosionRadius(ServerLevel level, Vec3 explosionCenter, float radius) {
        HashSet<BlockPos> blocksToBreak = new HashSet<BlockPos>();
        int radiusInt = (int)Math.ceil(radius);
        BlockPos explosionPos = BlockPos.containing((double)explosionCenter.x, (double)explosionCenter.y, (double)explosionCenter.z);
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int y = -radiusInt; y <= radiusInt; ++y) {
                for (int z = -radiusInt; z <= radiusInt; ++z) {
                    int damageAmount;
                    BlockPos checkPos = explosionPos.offset(x, y, z);
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (distance > (double)radius) continue;
                    BlockState state = level.getBlockState(checkPos);
                    if (state.is(Blocks.TNT)) {
                        blocksToBreak.add(checkPos);
                        continue;
                    }
                    if (!ExplosionHandler.shouldProcessBlock(level, explosionCenter, checkPos, state) || !ExplosionHandler.applyBlockDamage(level, checkPos, damageAmount = ExplosionHandler.calculateDamageAmount(distance, radius))) continue;
                    blocksToBreak.add(checkPos);
                }
            }
        }
        return blocksToBreak;
    }

    private static boolean shouldProcessBlock(ServerLevel level, Vec3 explosionCenter, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return false;
        }
        if (ModConfig.isProtectiveBlock(state.getBlock())) {
            return false;
        }
        return !ExplosionHandler.isBlockedByProtectiveBlock(level, explosionCenter, pos);
    }

    private static boolean isBlockedByProtectiveBlock(ServerLevel level, Vec3 explosionCenter, BlockPos targetPos) {
        double step;
        Vec3 targetCenter = Vec3.atCenterOf((Vec3i)targetPos);
        Vec3 direction = targetCenter.subtract(explosionCenter).normalize();
        double distance = explosionCenter.distanceTo(targetCenter);
        for (double d = step = 0.5; d < distance; d += step) {
            BlockState state;
            Vec3 checkPoint = explosionCenter.add(direction.scale(d));
            BlockPos checkPos = BlockPos.containing((Position)checkPoint);
            if (checkPos.equals((Object)targetPos) || !ModConfig.isProtectiveBlock((state = level.getBlockState(checkPos)).getBlock())) continue;
            return true;
        }
        return false;
    }

    private static int calculateDamageAmount(double distance, float radius) {
        double normalizedDistance = distance / (double)radius;
        double radiusMultiplier = Math.max(1.0, (double)radius / 4.0);
        double distanceMultiplier = 3.0 - 2.0 * normalizedDistance;
        return Math.max(1, (int)Math.round(distanceMultiplier * radiusMultiplier));
    }

    private static boolean applyBlockDamage(ServerLevel level, BlockPos pos, int damageAmount) {
        BlockState state = level.getBlockState(pos);
        int requiredHits = ModConfig.getHitsForBlock(state.getBlock());
        BlockDamageData damageData = BlockDamageManager.getDamageData(level, pos);
        int currentDamage = damageData.damage() + damageAmount;
        if (currentDamage >= requiredHits) {
            BlockDamageManager.removeDamage(level, pos);
            return true;
        }
        BlockDamageManager.setDamage(level, pos, currentDamage);
        ExplosionHandler.showDamageEffects(level, pos, currentDamage, requiredHits);
        return false;
    }

    private static void updateAffectedBlocksList(List<BlockPos> affectedBlocks, Set<BlockPos> blocksToBreak) {
        affectedBlocks.removeIf(pos -> !blocksToBreak.contains(pos));
        for (BlockPos pos2 : blocksToBreak) {
            if (affectedBlocks.contains(pos2)) continue;
            affectedBlocks.add(pos2);
        }
    }

    private static void showDamageEffects(ServerLevel level, BlockPos pos, int damage, int maxDamage) {
        int damageStage = Math.min(9, (int)((float)damage / (float)maxDamage * 10.0f));
        level.destroyBlockProgress(-1 - pos.hashCode(), pos, damageStage);
    }
}

