/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage.config;

import com.king_tajin.block_explosion_damage.config.ConfigFileHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.block.Block;

public class ModConfig {
    private static double defaultHitsMultiplier = 6.0;
    private static int damageDecayTime = 2400;
    private static final Map<Block, Integer> customBlockHits = new HashMap<Block, Integer>();
    private static final Set<Block> protectiveBlocks = new HashSet<Block>();

    public static void init() {
        Block block;
        ConfigFileHandler.ConfigData config = ConfigFileHandler.loadConfig();
        defaultHitsMultiplier = config.defaultHitsMultiplier;
        damageDecayTime = config.damageDecayTime;
        customBlockHits.clear();
        for (Map.Entry<String, Integer> entry : config.customBlockHits.entrySet()) {
            block = ConfigFileHandler.getBlockFromString(entry.getKey());
            if (block == null) continue;
            customBlockHits.put(block, entry.getValue());
        }
        protectiveBlocks.clear();
        for (String blockId : config.protectiveBlocks) {
            block = ConfigFileHandler.getBlockFromString(blockId);
            if (block == null) continue;
            protectiveBlocks.add(block);
        }
    }

    public static int getHitsForBlock(Block block) {
        if (customBlockHits.containsKey(block)) {
            return customBlockHits.get(block);
        }
        float hardness = block.defaultDestroyTime();
        if (hardness < 0.0f) {
            return 999;
        }
        return Math.max(1, (int)Math.ceil((double)hardness * defaultHitsMultiplier));
    }

    public static boolean isProtectiveBlock(Block block) {
        return protectiveBlocks.contains(block);
    }

    public static int getDamageDecayTime() {
        return damageDecayTime;
    }
}

