/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage;

import com.king_tajin.block_explosion_damage.BlockDamageEventHandler;
import com.king_tajin.block_explosion_damage.BlockDamageManager;
import com.king_tajin.block_explosion_damage.ChunkDamageData;
import com.king_tajin.block_explosion_damage.ExplosionHandler;
import com.king_tajin.block_explosion_damage.ModCommands;
import com.king_tajin.block_explosion_damage.ModGameRules;
import com.king_tajin.block_explosion_damage.config.ModConfig;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@Mod(value="block_explosion_damage")
public class BlockExplosionDamage {
    public BlockExplosionDamage(IEventBus modEventBus) {
        modEventBus.addListener(this::commonSetup);
        BlockDamageManager.ATTACHMENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new BlockDamageEventHandler());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModConfig.init();
        ModGameRules.register();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess;
        if (event.getLevel() instanceof ServerLevel && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            ChunkDamageData chunkData = (ChunkDamageData)chunk.getData(BlockDamageManager.CHUNK_DAMAGE);
            BlockDamageManager.registerLoadedChunk(chunk.getPos(), chunkData);
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplosionHandler.handleExplosion(serverLevel, event.getExplosion(), event.getAffectedBlocks());
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.getGameTime() % 20L == 0L) {
                BlockDamageManager.processDecay(serverLevel);
            }
            if (serverLevel.getGameTime() % 10L == 0L) {
                BlockDamageManager.refreshVisuals(serverLevel);
            }
        }
    }
}

