/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage;

import com.king_tajin.block_explosion_damage.BlockDamageData;
import com.king_tajin.block_explosion_damage.config.ModConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class ChunkDamageData
implements INBTSerializable<CompoundTag> {
    private final Map<BlockPos, BlockDamageData> damageMap = new HashMap<BlockPos, BlockDamageData>();

    public BlockDamageData getDamage(BlockPos pos) {
        return this.damageMap.getOrDefault(pos, new BlockDamageData(0, 0L));
    }

    public void setDamage(BlockPos pos, int damage, long time) {
        this.damageMap.put(pos.immutable(), new BlockDamageData(damage, time));
    }

    public void removeDamage(BlockPos pos) {
        this.damageMap.remove(pos);
    }

    public boolean isEmpty() {
        return this.damageMap.isEmpty();
    }

    public void refreshVisuals(ServerLevel level) {
        for (Map.Entry<BlockPos, BlockDamageData> entry : this.damageMap.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockDamageData data = entry.getValue();
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) continue;
            int maxDamage = ModConfig.getHitsForBlock(state.getBlock());
            int damageStage = Math.min(9, (int)((float)data.damage() / (float)maxDamage * 10.0f));
            level.destroyBlockProgress(-1 - pos.hashCode(), pos, damageStage);
        }
    }

    public boolean processDecay(ServerLevel level, long currentTime, int decayTime) {
        Iterator<Map.Entry<BlockPos, BlockDamageData>> iterator = this.damageMap.entrySet().iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, BlockDamageData> entry = iterator.next();
            BlockPos pos = entry.getKey();
            BlockDamageData data = entry.getValue();
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                iterator.remove();
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
                modified = true;
                continue;
            }
            long timeSinceDamage = currentTime - data.lastDamageTime();
            if (timeSinceDamage < (long)decayTime) continue;
            int newDamage = data.damage() - 1;
            if (newDamage <= 0) {
                iterator.remove();
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
            } else {
                entry.setValue(new BlockDamageData(newDamage, currentTime));
                int maxDamage = ModConfig.getHitsForBlock(state.getBlock());
                int damageStage = Math.min(9, (int)((float)newDamage / (float)maxDamage * 10.0f));
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, damageStage);
            }
            modified = true;
        }
        return modified;
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<BlockPos, BlockDamageData> entry : this.damageMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            BlockPos pos = entry.getKey();
            BlockDamageData data = entry.getValue();
            entryTag.putInt("x", pos.getX());
            entryTag.putInt("y", pos.getY());
            entryTag.putInt("z", pos.getZ());
            entryTag.putInt("damage", data.damage());
            entryTag.putLong("time", data.lastDamageTime());
            listTag.add((Object)entryTag);
        }
        tag.put("blocks", (Tag)listTag);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag tag) {
        this.damageMap.clear();
        ListTag listTag = tag.getList("blocks", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag entryTag = listTag.getCompound(i);
            BlockPos pos = new BlockPos(entryTag.getInt("x"), entryTag.getInt("y"), entryTag.getInt("z"));
            int damage = entryTag.getInt("damage");
            long time = entryTag.getLong("time");
            this.damageMap.put(pos, new BlockDamageData(damage, time));
        }
    }

    public int clearAllDamage(ServerLevel level) {
        int count = this.damageMap.size();
        for (BlockPos pos : this.damageMap.keySet()) {
            level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
        }
        this.damageMap.clear();
        return count;
    }
}

