/*
 * Decompiled with CFR 0.152.
 */
package me.unknowntexture.fancyblockoverlay.utils;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class ModifiedGuiSlider
extends GuiButton {
    private boolean isDragging = false;
    private double minValue;
    private double maxValue;
    private double sliderStep;
    private double stepValue;
    private double sliderValue;
    private DecimalFormat decimalFormat;
    private String sliderText;

    public ModifiedGuiSlider(int buttonId, int x, int y, int width, int height, String sliderText, float minValue, float maxValue, int minDisplayValue, int maxDisplayValue, float currentValue, String pattern) {
        super(buttonId, x, y, width, height, sliderText);
        this.minValue = minValue;
        this.maxValue = maxValue;
        int slots = maxDisplayValue - minDisplayValue;
        this.sliderStep = 1.0 / (double)slots;
        this.stepValue = (this.maxValue - this.minValue) / (double)slots;
        this.sliderValue = (double)(currentValue - minValue) / (double)(maxValue - minValue);
        this.decimalFormat = new DecimalFormat(pattern);
        this.sliderText = sliderText;
        this.updateDisplayString();
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.isDragging) {
                double mouseValue = (double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8);
                if (mouseValue < 0.0) {
                    mouseValue = 0.0;
                } else if (mouseValue > 1.0) {
                    mouseValue = 1.0;
                }
                this.sliderValue = (double)((int)Math.round(mouseValue / this.sliderStep)) * this.sliderStep;
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            double mouseValue = (double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8);
            if (mouseValue < 0.0) {
                mouseValue = 0.0;
            } else if (mouseValue > 1.0) {
                mouseValue = 1.0;
            }
            this.sliderValue = (double)((int)Math.round(mouseValue / this.sliderStep)) * this.sliderStep;
            this.updateSlider();
            this.isDragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.isDragging = false;
    }

    public void updateSlider() {
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        } else if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.updateDisplayString();
    }

    private void updateDisplayString() {
        this.field_146126_j = this.sliderText.replace("{value}", this.decimalFormat.format((double)((int)Math.round(this.sliderValue / this.sliderStep)) + this.minValue));
    }

    public void add(int n) {
        this.sliderValue = (double)Math.round((this.sliderValue += this.sliderStep * (double)n) * 10000.0) / 10000.0;
        this.updateSlider();
    }

    public void subtract(int n) {
        double newValue = this.sliderValue -= this.sliderStep * (double)n;
        if (newValue < 0.0) {
            newValue = 0.0;
        }
        this.sliderValue = newValue;
        this.updateSlider();
    }

    public float getMaxValue() {
        return (float)this.maxValue;
    }

    public float getMinValue() {
        return (float)this.minValue;
    }

    public float getValue() {
        return (float)(this.stepValue * (double)((int)Math.round(this.sliderValue / this.sliderStep)) + (double)this.getMinValue());
    }
}

