/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.api.block.IDial;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageDialUpdateRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DialBaseBlock
extends DirectionalBlock
implements IDial,
EntityBlock,
SimpleWaterloggedBlock {
    protected static final VoxelShape UP_INTERACTION = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.125, (double)0.6875);
    protected static final VoxelShape DOWN_INTERACTION = Shapes.m_83048_((double)0.3125, (double)0.875, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    protected static final VoxelShape NORTH_INTERACTION = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.875, (double)0.6875, (double)0.6875, (double)1.0);
    protected static final VoxelShape SOUTH_INTERACTION = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.125);
    protected static final VoxelShape WEST_INTERACTION = Shapes.m_83048_((double)0.875, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    protected static final VoxelShape EAST_INTERACTION = Shapes.m_83048_((double)0.0, (double)0.3125, (double)0.3125, (double)0.125, (double)0.6875, (double)0.6875);
    protected static final VoxelShape UP_AABB = Shapes.m_83113_((VoxelShape)UP_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape DOWN_AABB = Shapes.m_83113_((VoxelShape)DOWN_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.875, (double)0.375, (double)0.625, (double)0.9375, (double)0.625), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape NORTH_AABB = Shapes.m_83113_((VoxelShape)NORTH_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.375, (double)0.875, (double)0.625, (double)0.625, (double)0.9375), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape SOUTH_AABB = Shapes.m_83113_((VoxelShape)SOUTH_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.375, (double)0.0625, (double)0.625, (double)0.625, (double)0.125), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape WEST_AABB = Shapes.m_83113_((VoxelShape)WEST_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.375, (double)0.375, (double)0.9375, (double)0.625, (double)0.625), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape EAST_AABB = Shapes.m_83113_((VoxelShape)EAST_INTERACTION, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.375, (double)0.375, (double)0.125, (double)0.625, (double)0.625), (BooleanOp)BooleanOp.f_82685_);

    public DialBaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)f_52588_)) {
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case UP: {
                return UP_INTERACTION;
            }
            case DOWN: {
                return DOWN_INTERACTION;
            }
            case EAST: {
                return EAST_INTERACTION;
            }
            case WEST: {
                return WEST_INTERACTION;
            }
            case SOUTH: {
                return SOUTH_INTERACTION;
            }
        }
        return NORTH_INTERACTION;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        if (state.m_60807_() && (blockEntity = level.m_7702_(pos.m_5484_((Direction)state.m_61143_((Property)f_52588_), -1))) != null && blockEntity.m_58898_()) {
            int power = state.m_60674_(blockEntity.m_58904_(), pos);
            if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61426_) != power) {
                blockEntity.m_58904_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(power)), 1);
                blockEntity.m_58904_().m_46717_(pos, state.m_60734_());
            }
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return DialBaseBlock.canAttach(pLevel, pPos, ((Direction)pState.m_61143_((Property)f_52588_)).m_122424_());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        return !pReader.m_8055_(pPos.m_121945_(pDirection)).m_60795_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return ((Direction)pState.m_61143_((Property)f_52588_)).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_52588_}).m_61104_(new Property[]{BlockStateProperties.f_61426_}).m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    public List<Component> getDisplayInfo(Level world, BlockPos pos, BlockState state, int maxLines) {
        ArrayList<Component> text = new ArrayList<Component>();
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            Direction facing = (Direction)state.m_61143_((Property)f_52588_);
            this.getBEData(facing, text, tileEntity, maxLines);
            BlockEntity blockEntity = world.m_7702_(pos.m_5484_(facing, -1));
            if (blockEntity instanceof IExtraDialInformation) {
                IExtraDialInformation facingTile = (IExtraDialInformation)blockEntity;
                facingTile.addDialInformation(facing, text, this.getDialType());
            }
        }
        return text;
    }

    protected abstract void getBEData(Direction var1, ArrayList<Component> var2, BlockEntity var3, int var4);

    @Override
    public void updateBEData(BlockPos pos, int maxLines) {
        PacketHandler.INSTANCE.sendToServer((Object)new MessageDialUpdateRequest(pos, maxLines));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)f_52588_)));
    }
}

