/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.PipeBlockBase;
import com.rekindled.embers.blockentity.EmberEmitterBlockEntity;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.util.Misc;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EmberEmitterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape UP_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.m_49796_((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0), Block.m_49796_((double)5.0, (double)12.0, (double)7.0, (double)11.0, (double)14.0, (double)9.0)});
    protected static final VoxelShape DOWN_AABB = Misc.rotateVoxelShape(Direction.DOWN, UP_AABB);
    protected static final VoxelShape NORTH_AABB = Misc.rotateVoxelShape(Direction.NORTH, UP_AABB);
    protected static final VoxelShape SOUTH_AABB = Misc.rotateVoxelShape(Direction.SOUTH, UP_AABB);
    protected static final VoxelShape WEST_AABB = Misc.rotateVoxelShape(Direction.WEST, UP_AABB);
    protected static final VoxelShape EAST_AABB = Misc.rotateVoxelShape(Direction.EAST, UP_AABB);
    protected static final VoxelShape UP_INTERACTION = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75);
    protected static final VoxelShape DOWN_INTERACTION = Shapes.m_83048_((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    protected static final VoxelShape NORTH_INTERACTION = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0625, (double)0.75, (double)0.75, (double)1.0);
    protected static final VoxelShape SOUTH_INTERACTION = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.9375);
    protected static final VoxelShape WEST_INTERACTION = Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75);
    protected static final VoxelShape EAST_INTERACTION = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.9375, (double)0.75, (double)0.75);
    protected static final VoxelShape SUPPORT_X = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0, (double)0.0, (double)0.9, (double)1.0, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.9, (double)0.0, (double)1.0, (double)1.0, (double)1.0)});
    protected static final VoxelShape SUPPORT_Y = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0, (double)0.0, (double)0.9, (double)1.0, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.9, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)});
    protected static final VoxelShape SUPPORT_Z = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0, (double)0.9, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.9, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)});
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final Direction[] X_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};
    public static final Direction[] Y_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] Z_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST};
    public static final BooleanProperty[] DIRECTIONS = new BooleanProperty[]{BooleanProperty.m_61465_((String)"front"), BooleanProperty.m_61465_((String)"right"), BooleanProperty.m_61465_((String)"back"), BooleanProperty.m_61465_((String)"left")};
    public static final BooleanProperty[] ALL_DIRECTIONS = new BooleanProperty[]{BlockStateProperties.f_61367_, BlockStateProperties.f_61366_, BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_};
    public VoxelShape[][] shapeCache = new VoxelShape[6][16];

    public EmberEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DIRECTIONS[0], (Comparable)Boolean.valueOf(false))).m_61124_((Property)DIRECTIONS[1], (Comparable)Boolean.valueOf(false))).m_61124_((Property)DIRECTIONS[2], (Comparable)Boolean.valueOf(false))).m_61124_((Property)DIRECTIONS[3], (Comparable)Boolean.valueOf(false)));
    }

    public static int getIndexForDirection(Direction.Axis axis, Direction direction) {
        int index = direction.m_122411_();
        switch (axis) {
            case Z: {
                return index > 1 ? index - 2 : index;
            }
            case Y: {
                return index - 2;
            }
        }
        return index;
    }

    public static Direction getDirectionForIndex(Direction.Axis axis, int index) {
        switch (axis) {
            case X: {
                return X_DIRECTIONS[index];
            }
            case Z: {
                return Z_DIRECTIONS[index];
            }
        }
        return Y_DIRECTIONS[index];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return EmberEmitterBlock.addPipeConnections(state, UP_AABB, this.shapeCache);
            }
            case DOWN: {
                return EmberEmitterBlock.addPipeConnections(state, DOWN_AABB, this.shapeCache);
            }
            case EAST: {
                return EmberEmitterBlock.addPipeConnections(state, EAST_AABB, this.shapeCache);
            }
            case WEST: {
                return EmberEmitterBlock.addPipeConnections(state, WEST_AABB, this.shapeCache);
            }
            case SOUTH: {
                return EmberEmitterBlock.addPipeConnections(state, SOUTH_AABB, this.shapeCache);
            }
        }
        return EmberEmitterBlock.addPipeConnections(state, NORTH_AABB, this.shapeCache);
    }

    public static VoxelShape addPipeConnections(BlockState state, VoxelShape shape, VoxelShape[][] cache) {
        int face = ((Direction)state.m_61143_((Property)FACING)).m_122411_();
        int cacheValue = 0;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            cacheValue *= 2;
            cacheValue += ((Boolean)state.m_61143_((Property)DIRECTIONS[i])).compareTo(false);
        }
        if (cache[face][cacheValue] != null) {
            return cache[face][cacheValue];
        }
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (!((Boolean)state.m_61143_((Property)DIRECTIONS[i])).booleanValue()) continue;
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PipeBlockBase.END_AABBS[EmberEmitterBlock.getDirectionForIndex(axis, i).m_122411_()], (BooleanOp)BooleanOp.f_82695_);
        }
        cache[face][cacheValue] = shape.m_83296_();
        return cache[face][cacheValue];
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return UP_INTERACTION;
            }
            case DOWN: {
                return DOWN_INTERACTION;
            }
            case EAST: {
                return EAST_INTERACTION;
            }
            case WEST: {
                return WEST_INTERACTION;
            }
            case SOUTH: {
                return SOUTH_INTERACTION;
            }
        }
        return NORTH_INTERACTION;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return EmberEmitterBlock.canAttach(pLevel, pPos, ((Direction)pState.m_61143_((Property)FACING)).m_122424_());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        return !pReader.m_8055_(pPos.m_121945_(pDirection)).m_60795_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                Direction facing = EmberEmitterBlock.getDirectionForIndex(direction.m_122434_(), i);
                blockstate = (BlockState)blockstate.m_61124_((Property)DIRECTIONS[i], (Comparable)Boolean.valueOf(EmberEmitterBlock.connected(facing, pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(facing)))));
            }
            return (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (((Direction)pState.m_61143_((Property)FACING)).m_122434_() != pFacing.m_122434_()) {
            pState = (BlockState)pState.m_61124_((Property)DIRECTIONS[EmberEmitterBlock.getIndexForDirection(((Direction)pState.m_61143_((Property)FACING)).m_122434_(), pFacing)], (Comparable)Boolean.valueOf(EmberEmitterBlock.connected(pFacing, pFacingState)));
        }
        return ((Direction)pState.m_61143_((Property)FACING)).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static boolean facingConnected(Direction facing, BlockState state, DirectionProperty property) {
        return !state.m_61138_((Property)property) || state.m_61143_((Property)property) == facing;
    }

    private static boolean connected(Direction direction, BlockState state) {
        if (!state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION)) {
            return false;
        }
        if (state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION_FLOOR) || state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION_CEILING)) {
            if (direction == Direction.DOWN && state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION_CEILING)) {
                return true;
            }
            return direction == Direction.UP;
        }
        BooleanProperty sideProp = ALL_DIRECTIONS[direction.m_122424_().m_122411_()];
        if (state.m_61138_((Property)sideProp) && ((Boolean)state.m_61143_((Property)sideProp)).booleanValue()) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61377_) && state.m_61143_((Property)BlockStateProperties.f_61377_) == BellAttachType.CEILING && direction == Direction.DOWN) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            if (direction == Direction.DOWN && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_)).booleanValue()) {
                return true;
            }
            return direction == Direction.UP && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) == false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61365_) && !state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == direction.m_122434_();
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61376_) && state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.WALL) {
            if (direction == Direction.DOWN && state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING) {
                return true;
            }
            return direction == Direction.UP && state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.FLOOR;
        }
        return EmberEmitterBlock.facingConnected(direction, state, BlockStateProperties.f_61374_) && EmberEmitterBlock.facingConnected(direction, state, BlockStateProperties.f_61372_) && EmberEmitterBlock.facingConnected(direction, state, BlockStateProperties.f_61373_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_((Property[])DIRECTIONS).m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.EMBER_EMITTER_ENTITY.get()).m_155264_(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : EmberEmitterBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.EMBER_EMITTER_ENTITY.get()), EmberEmitterBlockEntity::serverTick);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        switch (((Direction)pState.m_61143_((Property)FACING)).m_122434_()) {
            case X: {
                return SUPPORT_X;
            }
            case Y: {
                return SUPPORT_Y;
            }
        }
        return SUPPORT_Z;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }
}

