/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.blockentity.FluidVesselBlockEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidVesselBlock
extends AbstractCauldronBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    protected static final VoxelShape VESSEL_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0), Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0), Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0), Block.m_49796_((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0), Block.m_49796_((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0)});

    public FluidVesselBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FluidVesselBlockEntity) {
            FluidVesselBlockEntity vesselEntity = (FluidVesselBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (!heldItem.m_41619_()) {
                boolean didFill;
                IFluidHandler cap = (IFluidHandler)vesselEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).orElse(null);
                if (cap != null && (didFill = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)cap))) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                    return InteractionResult.CONSUME_PARTIAL;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VESSEL_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean m_151979_(BlockState state, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }

    public boolean m_142596_(BlockState state) {
        return false;
    }

    public boolean m_142087_(Fluid fluid) {
        return true;
    }

    public void m_142310_(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        FluidVesselBlockEntity vesselEntity;
        IFluidHandler cap;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FluidVesselBlockEntity && (cap = (IFluidHandler)(vesselEntity = (FluidVesselBlockEntity)blockEntity).getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null)) != null) {
            int amount = 333;
            if (fluid == Fluids.f_76195_) {
                amount = 1000;
            }
            cap.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
            if (fluid.getFluidType().getTemperature() > 500) {
                level.m_46796_(1046, pos, 0);
            } else {
                level.m_46796_(1047, pos, 0);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.FLUID_VESSEL_ENTITY.get()).m_155264_(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? BaseEntityBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.FLUID_VESSEL_ENTITY.get()), FluidVesselBlockEntity::clientTick) : null;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        CompoundTag nbt;
        List items = super.m_49635_(pState, pBuilder);
        BlockEntity blockentity = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof FluidVesselBlockEntity && (nbt = blockentity.m_187482_()) != null) {
            for (ItemStack stack : items) {
                IFluidHandler cap;
                if (stack.m_41720_() != RegistryManager.FLUID_VESSEL_ITEM.get() || (cap = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)) == null) continue;
                cap.fill(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return items;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

