/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IHammerable;
import com.rekindled.embers.api.tile.IMechanicallyPowered;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class AutomaticHammerBlockEntity
extends BlockEntity
implements IMechanicallyPowered,
IExtraDialInformation,
IUpgradeable,
IExtraCapabilityInformation {
    public static final double EMBER_COST = 40.0;
    public static final int PROCESS_TIME = 20;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            AutomaticHammerBlockEntity.this.m_6596_();
        }
    };
    public long startTime = -1L;
    public int processTime = -1;
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();

    public AutomaticHammerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.AUTOMATIC_HAMMER_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(12000.0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, -1, -1), this.f_58858_.m_7918_(2, 2, 2));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        this.startTime = nbt.m_128454_("startTime");
        this.processTime = nbt.m_128451_("processTime");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128356_("startTime", this.startTime);
        nbt.m_128405_("processTime", this.processTime);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128356_("startTime", this.startTime);
        nbt.m_128405_("processTime", this.processTime);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AutomaticHammerBlockEntity blockEntity) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{facing.m_122424_()});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AutomaticHammerBlockEntity blockEntity) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{facing.m_122424_()});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        BlockEntity tile = level.m_7702_(pos.m_7495_().m_121945_(facing));
        if (tile instanceof IHammerable) {
            double ember_cost = UpgradeUtil.getTotalEmberConsumption(blockEntity, 40.0, blockEntity.upgrades);
            IHammerable hammerable = (IHammerable)tile;
            boolean redstoneEnabled = level.m_276867_(pos);
            if (hammerable.isValid() && redstoneEnabled && blockEntity.capability.getEmber() >= ember_cost) {
                boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
                int processTime = UpgradeUtil.getWorkTime(blockEntity, 20, blockEntity.upgrades);
                if (!cancel && blockEntity.startTime + (long)processTime < level.m_46467_()) {
                    blockEntity.startTime = level.m_46467_();
                    blockEntity.processTime = processTime;
                    blockEntity.m_6596_();
                }
            }
            if (blockEntity.startTime + (long)(blockEntity.processTime / 2) == level.m_46467_() && blockEntity.capability.getEmber() >= ember_cost) {
                UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, ember_cost), blockEntity.upgrades);
                blockEntity.capability.removeAmount(ember_cost, true);
                hammerable.onHit(blockEntity);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 20.0, 0.075);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getMinimumPower() {
        return 10.0;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return this.m_58900_().m_61138_((Property)BlockStateProperties.f_61374_) && ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() == face;
    }

    @Override
    public void addOtherDescription(List<Component> strings, Direction facing) {
        strings.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.redstone_signal"));
    }
}

