/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.block.EmberDialBlock;
import com.rekindled.embers.block.ItemDialBlock;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CopperChargerBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            CopperChargerBlockEntity.this.m_6596_();
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).isPresent();
        }

        protected void onContentsChanged(int slot) {
            CopperChargerBlockEntity.this.m_6596_();
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    public int angle = 0;
    public int turnRate = 1;
    static Random random = new Random();
    public boolean isWorking;
    public boolean wasWorking;
    public boolean reverse = false;
    protected List<UpgradeContext> upgrades;
    public static final int SOUND_PROCESS = 1;
    public static final int SOUND_REVERSE = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    HashSet<Integer> soundsPlaying = new HashSet();

    public CopperChargerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.COPPER_CHARGER_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(24000.0);
        this.capability.setEmber(0.0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
        this.isWorking = nbt.m_128471_("working");
        this.reverse = nbt.m_128471_("reverse");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.capability.writeToNBT(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128379_("working", this.isWorking);
        nbt.m_128379_("reverse", this.reverse);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CopperChargerBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.handleSound();
        blockEntity.angle += blockEntity.turnRate;
        if (blockEntity.isWorking && blockEntity.capability.getEmber() > 0.0) {
            int i = 0;
            while ((double)i < Math.ceil(blockEntity.capability.getEmber() / 500.0)) {
                level.m_7106_((ParticleOptions)GlowParticleOptions.EMBER, (double)((float)pos.m_123341_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123342_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123343_() + 0.25f + random.nextFloat() * 0.5f), (Math.random() * 2.0 - 1.0) * 0.2, (Math.random() * 2.0 - 1.0) * 0.2, (Math.random() * 2.0 - 1.0) * 0.2);
                ++i;
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CopperChargerBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        ItemStack stack = blockEntity.inventory.getStackInSlot(0);
        blockEntity.wasWorking = blockEntity.isWorking;
        blockEntity.isWorking = false;
        IEmberCapability itemCapability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).orElse(null);
        boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
        if (!cancel && itemCapability != null) {
            double emberAdded;
            double transferRate = UpgradeUtil.getTotalSpeedModifier(blockEntity, blockEntity.upgrades) * (Double)ConfigManager.CHARGER_MAX_TRANSFER.get();
            if (transferRate > 0.0) {
                emberAdded = itemCapability.addAmount(Math.min(Math.abs(transferRate), blockEntity.capability.getEmber()), true);
                blockEntity.capability.removeAmount(emberAdded, true);
                blockEntity.reverse = false;
            } else {
                emberAdded = blockEntity.capability.addAmount(Math.min(Math.abs(transferRate), itemCapability.getEmber()), true);
                itemCapability.removeAmount(emberAdded, true);
                blockEntity.reverse = true;
            }
            if (emberAdded > 0.0) {
                UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.TRANSFER, emberAdded), blockEntity.upgrades);
                blockEntity.isWorking = true;
            }
        }
        if (blockEntity.wasWorking != blockEntity.isWorking) {
            blockEntity.m_6596_();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_) {
            if (cap == EmbersCapabilities.EMBER_CAPABILITY) {
                return this.capability.getCapability(cap, side);
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.COPPER_CHARGER_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
                break;
            }
            case 2: {
                EmbersSounds.playMachineSound(this, 2, (SoundEvent)EmbersSounds.COPPER_CHARGER_SIPHON_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return this.isWorking && (this.reverse ? id == 2 : id == 1);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        ItemStack stack;
        IEmberCapability itemCapability;
        if ("ember".equals(dialType) && (itemCapability = (IEmberCapability)(stack = this.inventory.getStackInSlot(0)).getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).orElse(null)) != null) {
            information.add((Component)ItemDialBlock.formatItemStack(stack));
            information.add((Component)EmberDialBlock.formatEmber(itemCapability.getEmber(), itemCapability.getEmberCapacity()));
        }
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember_storage")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return true;
    }
}

