/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.upgrade.EntropicEnumeratorUpgrade;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;

public class EntropicEnumeratorBlockEntity
extends BlockEntity
implements IExtraCapabilityInformation {
    public Cubie[][][] visualCube = new Cubie[2][2][2];
    public int previousMove = -10;
    public Cubie[][][] cube = new Cubie[][][]{{{new Cubie(new Vector3d(-1.0, -1.0, -1.0), new Vector3d(1.0, 2.0, 3.0)), new Cubie(new Vector3d(-1.0, -1.0, 1.0), new Vector3d(1.0, 2.0, 4.0))}, {new Cubie(new Vector3d(-1.0, 1.0, -1.0), new Vector3d(1.0, 5.0, 3.0)), new Cubie(new Vector3d(-1.0, 1.0, 1.0), new Vector3d(1.0, 5.0, 4.0))}}, {{new Cubie(new Vector3d(1.0, -1.0, -1.0), new Vector3d(6.0, 2.0, 3.0)), new Cubie(new Vector3d(1.0, -1.0, 1.0), new Vector3d(6.0, 2.0, 4.0))}, {new Cubie(new Vector3d(1.0, 1.0, -1.0), new Vector3d(6.0, 5.0, 3.0)), new Cubie(new Vector3d(1.0, 1.0, 1.0), new Vector3d(6.0, 5.0, 4.0))}}};
    public long nextMoveTime = -1L;
    public int moveOffset = -1;
    public Move[] moveQueue = new Move[0];
    public int[] offsetQueue = new int[0];
    public boolean solving;
    public boolean willFail;
    public static Random seededRand = new Random();
    public EntropicEnumeratorUpgrade upgrade = new EntropicEnumeratorUpgrade(this);
    public static final int GODS_NUMBER = 14;
    public static final Move[] B = new Move[]{Move.B};
    public static final Move[] L = new Move[]{Move.L};
    public static final Move[] L_ = new Move[]{Move.L_};
    public static final Move[] B_ = new Move[]{Move.B_};
    public static final Move[] U_ = new Move[]{Move.U_};
    public static final Move[] DB = new Move[]{Move.D, Move.B};
    public static final Move[] D_B = new Move[]{Move.D_, Move.B};
    public static final Move[] D2B = new Move[]{Move.D2, Move.B};
    public static final Move[] LB_ = new Move[]{Move.L, Move.B_};
    public static final Move[] DLB_ = new Move[]{Move.D, Move.L, Move.B_};
    public static final Move[] D2LB_ = new Move[]{Move.D2, Move.L, Move.B_};
    public static final Move[] B2 = new Move[]{Move.B2};
    public static final Move[] L2 = new Move[]{Move.L2};
    public static final Move[] DB2 = new Move[]{Move.D, Move.B2};
    public static final Move[] D_B2 = new Move[]{Move.D_, Move.B2};
    public static final Move[] D2B2 = new Move[]{Move.D2, Move.B2};
    public static final Move[] L_B_ = new Move[]{Move.L_, Move.B_};
    public static final Move[] LD_B2 = new Move[]{Move.L, Move.D_, Move.B2};
    public static final Move[] BDL_U_ = new Move[]{Move.B, Move.D, Move.L_, Move.U_};
    public static final Move[] B2DL_U_ = new Move[]{Move.B2, Move.D, Move.L_, Move.U_};
    public static final Move[] L_U_ = new Move[]{Move.L_, Move.U_};
    public static final Move[] DL_U_ = new Move[]{Move.D, Move.L_, Move.U_};
    public static final Move[] LU_ = new Move[]{Move.L, Move.U_};
    public static final Move[] BLU_ = new Move[]{Move.B, Move.L, Move.U_};
    public static final Move[] DL = new Move[]{Move.D, Move.L};
    public static final Move[] L2D_L = new Move[]{Move.L2, Move.D_, Move.L};
    public static final Move[] DL2 = new Move[]{Move.D, Move.L2};
    public static final Move[] BL_B_ = new Move[]{Move.B, Move.L_, Move.B_};
    public static final Move[] D2L = new Move[]{Move.D2, Move.L};
    public static final Move[] D2L2 = new Move[]{Move.D2, Move.L2};
    public static final Move[] D_L = new Move[]{Move.D_, Move.L};
    public static final Move[] D_L2 = new Move[]{Move.D_, Move.L2};
    public static final Move[] D2L_U_ = new Move[]{Move.D2, Move.L_, Move.U_};
    public static final Move[] D_L_U_ = new Move[]{Move.D_, Move.L_, Move.U_};
    public static final Move[] F_DF = new Move[]{Move.F_, Move.D, Move.F};
    public static final Move[] LDLD_L2 = new Move[]{Move.L, Move.D, Move.L, Move.D_, Move.L2};
    public static final Move[] F_D_F_DF2 = new Move[]{Move.F_, Move.D_, Move.F_, Move.D, Move.F2};
    public static final Move[] DL2D_L2 = new Move[]{Move.D, Move.L2, Move.D_, Move.L2};
    public static final Move[] LD_L_ = new Move[]{Move.L, Move.D_, Move.L_};
    public static final Move[] F_D2F = new Move[]{Move.F_, Move.D2, Move.F};
    public static final Move[] F_D_F = new Move[]{Move.F_, Move.D_, Move.F};
    public static final Move[] LDL_ = new Move[]{Move.L, Move.D, Move.L_};
    public static final Move[] L2D_L2 = new Move[]{Move.L2, Move.D_, Move.L2};
    public static final Move[] F2DF2 = new Move[]{Move.F2, Move.D, Move.F2};
    public static final Move[] D2F_DF = new Move[]{Move.D2, Move.F_, Move.D, Move.F};
    public static final Move[] D_L2D_L2 = new Move[]{Move.D_, Move.L2, Move.D_, Move.L2};
    public static final Move[] D_LD2L_ = new Move[]{Move.D_, Move.L, Move.D2, Move.L_};
    public static final Move[] LD2L_ = new Move[]{Move.L, Move.D2, Move.L_};
    public static final Move[] U = new Move[]{Move.U};
    public static final Move[] U2 = new Move[]{Move.U2};
    public static final Move[] D = new Move[]{Move.D};
    public static final Move[] D_ = new Move[]{Move.D_};
    public static final Move[] D2 = new Move[]{Move.D2};
    public static final Move[] OLL_H = new Move[]{Move.R2, Move.U2, Move.R, Move.U2, Move.R2};
    public static final Move[] OLL_PI = new Move[]{Move.R, Move.U2, Move.R2, Move.U_, Move.R2, Move.U_, Move.R2, Move.U2, Move.R};
    public static final Move[] OLL_ANTISUNE = new Move[]{Move.R, Move.U2, Move.R_, Move.U_, Move.R, Move.U_, Move.R_};
    public static final Move[] OLL_SUNE = new Move[]{Move.R, Move.U, Move.R_, Move.U, Move.R, Move.U2, Move.R_};
    public static final Move[] OLL_L = new Move[]{Move.F, Move.R_, Move.F_, Move.R, Move.U, Move.R, Move.U_, Move.R_};
    public static final Move[] OLL_T = new Move[]{Move.R, Move.U, Move.R_, Move.U_, Move.R_, Move.F, Move.R, Move.F_};
    public static final Move[] OLL_U = new Move[]{Move.F, Move.R, Move.U, Move.R_, Move.U_, Move.F_};
    public static final Move[] PBL_ADJ_ADJ = new Move[]{Move.R2, Move.U_, Move.B2, Move.U2, Move.R2, Move.U_, Move.R2};
    public static final Move[] PBL_ADJ_DIAG = new Move[]{Move.R, Move.U_, Move.R, Move.F2, Move.R_, Move.U, Move.R_};
    public static final Move[] PBL_DIAG_ADJ = new Move[]{Move.R_, Move.D, Move.R_, Move.F2, Move.R, Move.D_, Move.R};
    public static final Move[] PBL_DIAG_DIAG = new Move[]{Move.L2, Move.B2, Move.R2};
    public static final Move[] PBL_ADJ_U = new Move[]{Move.R2, Move.F2, Move.R, Move.U, Move.R_, Move.F2, Move.R, Move.F_, Move.R};
    public static final Move[] PBL_ADJ_D = new Move[]{Move.R2, Move.F2, Move.R_, Move.D_, Move.R, Move.F2, Move.R_, Move.F, Move.R_};
    public static final Move[] PBL_DIAG_U = new Move[]{Move.R, Move.U_, Move.R_, Move.U_, Move.F2, Move.U_, Move.R, Move.U, Move.R_, Move.U, Move.F2};
    public static final Move[] PBL_DIAG_D = new Move[]{Move.R_, Move.D, Move.R, Move.D, Move.F2, Move.D, Move.R_, Move.D_, Move.R, Move.D_, Move.F2};
    public static int solvingMoveTime = 4;
    public static int moveTime = 13;
    public static int queueSize = 10;
    public static int queueTime = moveTime * queueSize;

    public EntropicEnumeratorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.ENTROPIC_ENUMERATOR_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    String key = "cubie_" + x + "_" + y + "_" + z;
                    if (!nbt.m_128441_(key)) continue;
                    CompoundTag cubieTag = nbt.m_128469_(key);
                    this.cube[x][y][z] = new Cubie(this.cube[x][y][z].basePosition, this.cube[x][y][z].baseColors, new Quaterniond(cubieTag.m_128459_("qx"), cubieTag.m_128459_("qy"), cubieTag.m_128459_("qz"), cubieTag.m_128459_("qw")));
                }
            }
        }
        if (nbt.m_128441_("nextMoveTime")) {
            this.nextMoveTime = nbt.m_128454_("nextMoveTime");
        }
        if (nbt.m_128441_("queue")) {
            ListTag queue = nbt.m_128437_("queue", 10);
            this.moveQueue = new Move[queue.size()];
            this.offsetQueue = new int[queue.size()];
            for (int i = 0; i < queue.size(); ++i) {
                this.moveQueue[i] = Move.valueOf(queue.m_128728_(i).m_128461_("move"));
                this.offsetQueue[i] = queue.m_128728_(i).m_128451_("offset");
            }
        }
        this.moveOffset = nbt.m_128451_("moveOffset");
        this.solving = nbt.m_128471_("solving");
        this.willFail = nbt.m_128471_("willFail");
        this.previousMove = -10;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.save(nbt);
    }

    public void save(CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    CompoundTag cubieTag = new CompoundTag();
                    cubieTag.m_128347_("qx", this.cube[x][y][z].rotation.x);
                    cubieTag.m_128347_("qy", this.cube[x][y][z].rotation.y);
                    cubieTag.m_128347_("qz", this.cube[x][y][z].rotation.z);
                    cubieTag.m_128347_("qw", this.cube[x][y][z].rotation.w);
                    nbt.m_128365_("cubie_" + x + "_" + y + "_" + z, (Tag)cubieTag);
                }
            }
        }
        if (this.nextMoveTime > 0L) {
            nbt.m_128356_("nextMoveTime", this.nextMoveTime);
        }
        ListTag queue = new ListTag();
        for (int i = 0; i < this.moveQueue.length; ++i) {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("move", this.moveQueue[i].name());
            entry.m_128405_("offset", this.offsetQueue[i]);
            queue.add(i, (Tag)entry);
        }
        nbt.m_128365_("queue", (Tag)queue);
        nbt.m_128405_("moveOffset", this.moveOffset);
        nbt.m_128379_("solving", this.solving);
        nbt.m_128379_("willFail", this.willFail);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.save(nbt);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void solveInefficient() {
        this.solving = true;
        this.applyCurrentQueue(this.cube);
        this.nextMoveTime = this.f_58857_.m_46467_() + (long)(moveTime / 2);
        Cubie[][][] cubeClone = new Cubie[2][2][2];
        boolean done = false;
        Move[] moves = new Move[14];
        int i = 0;
        while ((double)i < Math.pow(Move.quarterMoves.length, 14.0) && !done) {
            for (int j = 0; j < 14; ++j) {
                moves[j] = Move.quarterMoves[i % (Move.quarterMoves.length * (j + 1)) / (j + 1)];
            }
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        cubeClone[x][y][z] = new Cubie(this.cube[x][y][z].basePosition, this.cube[x][y][z].baseColors, new Quaterniond((Quaterniondc)this.cube[x][y][z].rotation));
                    }
                }
            }
            for (int k = 0; k < 14; ++k) {
                moves[k].makeMove(cubeClone);
                if (!EntropicEnumeratorBlockEntity.isSolved(cubeClone)) continue;
                this.moveQueue = new Move[k];
                for (int l = 0; l < k; ++l) {
                    this.moveQueue[l] = moves[l];
                }
                done = true;
                break;
            }
            ++i;
        }
        this.offsetQueue = new int[this.moveQueue.length];
        for (i = 0; i < this.moveQueue.length; ++i) {
            this.offsetQueue[i] = moveTime;
        }
        this.offsetQueue[0] = 0;
        this.m_6596_();
    }

    public static void updateColors(Cubie[][][] cube, Vector3d[][][] colors) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    colors[(int)(cube[x][y][z].getPos().x / 2.0 + 1.0)][(int)(cube[x][y][z].getPos().y / 2.0 + 1.0)][(int)(cube[x][y][z].getPos().z / 2.0 + 1.0)] = cube[x][y][z].getColors();
                }
            }
        }
    }

    public void applyCurrentQueue(Cubie[][][] cube) {
        int i;
        int currentMove = this.moveQueue.length - 1;
        long turnTicks = this.f_58857_.m_46467_() - this.nextMoveTime;
        for (i = 0; i < this.moveQueue.length - 1; ++i) {
            if (!((float)(turnTicks -= (long)this.offsetQueue[i]) < (float)this.offsetQueue[i + 1])) continue;
            currentMove = i;
            break;
        }
        for (i = 0; i <= currentMove; ++i) {
            this.moveQueue[i].makeMove(cube);
        }
    }

    public void solve(boolean direct, int delay, boolean fail) {
        int i;
        this.solving = true;
        this.applyCurrentQueue(this.cube);
        Cubie[][][] cubeClone = new Cubie[2][2][2];
        Vector3d[][][] colors = new Vector3d[2][2][2];
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    cubeClone[x][y][z] = new Cubie(this.cube[x][y][z].basePosition, this.cube[x][y][z].baseColors, new Quaterniond((Quaterniondc)this.cube[x][y][z].rotation));
                    colors[(int)(this.cube[x][y][z].getPos().x / 2.0 + 1.0)][(int)(this.cube[x][y][z].getPos().y / 2.0 + 1.0)][(int)(this.cube[x][y][z].getPos().z / 2.0 + 1.0)] = this.cube[x][y][z].getColors();
                }
            }
        }
        ArrayList<Move[]> algorithms = new ArrayList<Move[]>();
        double topColor = colors[0][1][0].y;
        if (colors[0][1][1].y != topColor) {
            if (colors[0][0][1].x == topColor) {
                algorithms.add(B);
                Move.makeMoves(cubeClone, B);
            } else if (colors[1][1][1].x == topColor) {
                algorithms.add(B_);
                Move.makeMoves(cubeClone, B_);
            } else if (colors[1][1][0].y == topColor) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
            } else if (colors[1][0][1].y == topColor) {
                algorithms.add(B2);
                Move.makeMoves(cubeClone, B2);
            } else if (colors[1][0][1].x == topColor) {
                algorithms.add(LB_);
                Move.makeMoves(cubeClone, LB_);
            } else if (colors[1][1][0].x == topColor) {
                algorithms.add(L_B_);
                Move.makeMoves(cubeClone, L_B_);
            } else if (colors[1][0][1].z == topColor) {
                algorithms.add(D_B);
                Move.makeMoves(cubeClone, D_B);
            } else if (colors[0][0][0].z == topColor) {
                algorithms.add(DB);
                Move.makeMoves(cubeClone, DB);
            } else if (colors[1][0][0].z == topColor) {
                algorithms.add(L_U_);
                Move.makeMoves(cubeClone, L_U_);
            } else if (colors[1][1][1].z == topColor) {
                algorithms.add(LU_);
                Move.makeMoves(cubeClone, LU_);
            } else if (colors[0][0][1].y == topColor) {
                algorithms.add(DB2);
                Move.makeMoves(cubeClone, DB2);
            } else if (colors[1][0][0].x == topColor) {
                algorithms.add(D2B);
                Move.makeMoves(cubeClone, D2B);
            } else if (colors[1][0][0].y == topColor) {
                algorithms.add(D_B2);
                Move.makeMoves(cubeClone, D_B2);
            } else if (colors[0][0][0].y == topColor) {
                algorithms.add(D2B2);
                Move.makeMoves(cubeClone, D2B2);
            } else if (colors[0][1][1].z == topColor) {
                algorithms.add(BLU_);
                Move.makeMoves(cubeClone, BLU_);
            } else if (colors[0][0][1].z == topColor) {
                algorithms.add(DLB_);
                Move.makeMoves(cubeClone, DLB_);
            } else if (colors[1][1][0].z == topColor) {
                algorithms.add(LD_B2);
                Move.makeMoves(cubeClone, LD_B2);
            } else if (colors[0][0][0].x == topColor) {
                algorithms.add(D2LB_);
                Move.makeMoves(cubeClone, D2LB_);
            } else if (colors[1][1][1].y == topColor) {
                algorithms.add(BDL_U_);
                Move.makeMoves(cubeClone, BDL_U_);
            } else if (colors[0][1][1].x == topColor) {
                algorithms.add(B2DL_U_);
                Move.makeMoves(cubeClone, B2DL_U_);
            }
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        if (colors[1][1][1].y != topColor) {
            if (colors[1][0][1].z == topColor) {
                algorithms.add(L);
                Move.makeMoves(cubeClone, L);
            } else if (colors[1][1][0].z == topColor) {
                algorithms.add(L_);
                Move.makeMoves(cubeClone, L_);
            } else if (colors[1][0][0].y == topColor) {
                algorithms.add(L2);
                Move.makeMoves(cubeClone, L2);
            } else if (colors[1][1][0].y == topColor) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
            } else if (colors[0][0][1].x == topColor) {
                algorithms.add(DL);
                Move.makeMoves(cubeClone, DL);
            } else if (colors[1][0][0].z == topColor) {
                algorithms.add(L_U_);
                Move.makeMoves(cubeClone, L_U_);
            } else if (colors[1][1][1].z == topColor) {
                algorithms.add(LU_);
                Move.makeMoves(cubeClone, LU_);
            } else if (colors[1][0][0].x == topColor) {
                algorithms.add(D_L);
                Move.makeMoves(cubeClone, D_L);
            } else if (colors[0][0][0].y == topColor) {
                algorithms.add(D_L2);
                Move.makeMoves(cubeClone, D_L2);
            } else if (colors[1][0][1].y == topColor) {
                algorithms.add(DL2);
                Move.makeMoves(cubeClone, DL2);
            } else if (colors[0][0][0].z == topColor) {
                algorithms.add(D2L);
                Move.makeMoves(cubeClone, D2L);
            } else if (colors[0][0][1].y == topColor) {
                algorithms.add(D2L2);
                Move.makeMoves(cubeClone, D2L2);
            } else if (colors[1][1][0].x == topColor) {
                algorithms.add(BL_B_);
                Move.makeMoves(cubeClone, BL_B_);
            } else if (colors[1][0][1].x == topColor) {
                algorithms.add(DL_U_);
                Move.makeMoves(cubeClone, DL_U_);
            } else if (colors[0][0][0].x == topColor) {
                algorithms.add(D_L_U_);
                Move.makeMoves(cubeClone, D_L_U_);
            } else if (colors[1][1][1].x == topColor) {
                algorithms.add(L2D_L);
                Move.makeMoves(cubeClone, L2D_L);
            } else if (colors[0][0][1].z == topColor) {
                algorithms.add(D2L_U_);
                Move.makeMoves(cubeClone, D2L_U_);
            }
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        if (colors[1][1][0].y != topColor) {
            if (colors[1][0][1].z == topColor) {
                algorithms.add(F_DF);
                Move.makeMoves(cubeClone, F_DF);
            } else if (colors[1][1][0].z == topColor) {
                algorithms.add(LDLD_L2);
                Move.makeMoves(cubeClone, LDLD_L2);
            } else if (colors[1][0][0].y == topColor) {
                algorithms.add(DL2D_L2);
                Move.makeMoves(cubeClone, DL2D_L2);
            } else if (colors[0][0][1].x == topColor) {
                algorithms.add(F_D2F);
                Move.makeMoves(cubeClone, F_D2F);
            } else if (colors[1][0][0].z == topColor) {
                algorithms.add(F_D_F);
                Move.makeMoves(cubeClone, F_D_F);
            } else if (colors[1][0][0].x == topColor) {
                algorithms.add(LDL_);
                Move.makeMoves(cubeClone, LDL_);
            } else if (colors[0][0][0].y == topColor) {
                algorithms.add(L2D_L2);
                Move.makeMoves(cubeClone, L2D_L2);
            } else if (colors[1][0][1].y == topColor) {
                algorithms.add(F2DF2);
                Move.makeMoves(cubeClone, F2DF2);
            } else if (colors[0][0][0].z == topColor) {
                algorithms.add(D2F_DF);
                Move.makeMoves(cubeClone, D2F_DF);
            } else if (colors[0][0][1].y == topColor) {
                algorithms.add(D_L2D_L2);
                Move.makeMoves(cubeClone, D_L2D_L2);
            } else if (colors[1][1][0].x == topColor) {
                algorithms.add(F_D_F_DF2);
                Move.makeMoves(cubeClone, F_D_F_DF2);
            } else if (colors[1][0][1].x == topColor) {
                algorithms.add(D_LD2L_);
                Move.makeMoves(cubeClone, D_LD2L_);
            } else if (colors[0][0][0].x == topColor) {
                algorithms.add(LD_L_);
                Move.makeMoves(cubeClone, LD_L_);
            } else if (colors[0][0][1].z == topColor) {
                algorithms.add(LD2L_);
                Move.makeMoves(cubeClone, LD2L_);
            }
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        topColor = 7.0 - topColor;
        int correctFaces = 0;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                if (colors[x][0][z].y != topColor) continue;
                ++correctFaces;
            }
        }
        if (correctFaces != 4) {
            algorithms.add(PBL_DIAG_DIAG);
            Move.makeMoves(cubeClone, PBL_DIAG_DIAG);
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        if (correctFaces == 0) {
            if (colors[0][1][0].z == topColor && colors[1][1][0].z == topColor) {
                if (colors[0][1][1].z == topColor) {
                    algorithms.add(OLL_H);
                    Move.makeMoves(cubeClone, OLL_H);
                } else {
                    algorithms.add(U);
                    Move.makeMoves(cubeClone, U);
                    algorithms.add(OLL_PI);
                    Move.makeMoves(cubeClone, OLL_PI);
                }
            } else if (colors[0][1][0].x == topColor && colors[0][1][1].x == topColor) {
                if (colors[1][1][0].x == topColor) {
                    algorithms.add(U_);
                    Move.makeMoves(cubeClone, U_);
                    algorithms.add(OLL_H);
                    Move.makeMoves(cubeClone, OLL_H);
                } else {
                    algorithms.add(U2);
                    Move.makeMoves(cubeClone, U2);
                    algorithms.add(OLL_PI);
                    Move.makeMoves(cubeClone, OLL_PI);
                }
            } else if (colors[0][1][1].z == topColor && colors[1][1][1].z == topColor) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
                algorithms.add(OLL_PI);
                Move.makeMoves(cubeClone, OLL_PI);
            } else {
                algorithms.add(OLL_PI);
                Move.makeMoves(cubeClone, OLL_PI);
            }
        } else if (correctFaces == 1) {
            if (colors[0][1][0].y == topColor) {
                if (colors[0][1][1].x == topColor) {
                    algorithms.add(U);
                    Move.makeMoves(cubeClone, U);
                    algorithms.add(OLL_SUNE);
                    Move.makeMoves(cubeClone, OLL_SUNE);
                } else {
                    algorithms.add(U_);
                    Move.makeMoves(cubeClone, U_);
                    algorithms.add(OLL_ANTISUNE);
                    Move.makeMoves(cubeClone, OLL_ANTISUNE);
                }
            } else if (colors[0][1][1].y == topColor) {
                if (colors[1][1][1].z == topColor) {
                    algorithms.add(U2);
                    Move.makeMoves(cubeClone, U2);
                    algorithms.add(OLL_SUNE);
                    Move.makeMoves(cubeClone, OLL_SUNE);
                } else {
                    algorithms.add(OLL_ANTISUNE);
                    Move.makeMoves(cubeClone, OLL_ANTISUNE);
                }
            } else if (colors[1][1][1].y == topColor) {
                if (colors[1][1][0].x == topColor) {
                    algorithms.add(U_);
                    Move.makeMoves(cubeClone, U_);
                    algorithms.add(OLL_SUNE);
                    Move.makeMoves(cubeClone, OLL_SUNE);
                } else {
                    algorithms.add(U);
                    Move.makeMoves(cubeClone, U);
                    algorithms.add(OLL_ANTISUNE);
                    Move.makeMoves(cubeClone, OLL_ANTISUNE);
                }
            } else if (colors[1][1][0].y == topColor) {
                if (colors[0][1][0].z == topColor) {
                    algorithms.add(OLL_SUNE);
                    Move.makeMoves(cubeClone, OLL_SUNE);
                } else {
                    algorithms.add(U2);
                    Move.makeMoves(cubeClone, U2);
                    algorithms.add(OLL_ANTISUNE);
                    Move.makeMoves(cubeClone, OLL_ANTISUNE);
                }
            }
        } else if (correctFaces == 2) {
            if (colors[0][1][0].y == topColor) {
                if (colors[0][1][1].y == topColor) {
                    if (colors[1][1][0].z == topColor) {
                        algorithms.add(OLL_T);
                        Move.makeMoves(cubeClone, OLL_T);
                    } else {
                        algorithms.add(OLL_U);
                        Move.makeMoves(cubeClone, OLL_U);
                    }
                } else if (colors[1][1][0].y == topColor) {
                    algorithms.add(U_);
                    Move.makeMoves(cubeClone, U_);
                    if (colors[1][1][1].x == topColor) {
                        algorithms.add(OLL_T);
                        Move.makeMoves(cubeClone, OLL_T);
                    } else {
                        algorithms.add(OLL_U);
                        Move.makeMoves(cubeClone, OLL_U);
                    }
                } else if (colors[1][1][1].y == topColor) {
                    if (colors[1][1][0].z == topColor) {
                        algorithms.add(OLL_L);
                        Move.makeMoves(cubeClone, OLL_L);
                    } else {
                        algorithms.add(U2);
                        Move.makeMoves(cubeClone, U2);
                        algorithms.add(OLL_L);
                        Move.makeMoves(cubeClone, OLL_L);
                    }
                }
            } else if (colors[1][1][1].y == topColor) {
                if (colors[0][1][1].y == topColor) {
                    algorithms.add(U);
                    Move.makeMoves(cubeClone, U);
                    if (colors[1][1][0].x == topColor) {
                        algorithms.add(OLL_T);
                        Move.makeMoves(cubeClone, OLL_T);
                    } else {
                        algorithms.add(OLL_U);
                        Move.makeMoves(cubeClone, OLL_U);
                    }
                } else if (colors[1][1][0].y == topColor) {
                    algorithms.add(U2);
                    Move.makeMoves(cubeClone, U2);
                    if (colors[0][1][0].z == topColor) {
                        algorithms.add(OLL_T);
                        Move.makeMoves(cubeClone, OLL_T);
                    } else {
                        algorithms.add(OLL_U);
                        Move.makeMoves(cubeClone, OLL_U);
                    }
                }
            } else if (colors[0][1][0].z == topColor) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
                algorithms.add(OLL_L);
                Move.makeMoves(cubeClone, OLL_L);
            } else {
                algorithms.add(U);
                Move.makeMoves(cubeClone, U);
                algorithms.add(OLL_L);
                Move.makeMoves(cubeClone, OLL_L);
            }
        }
        if (correctFaces != 4) {
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        PBLState topState = colors[0][1][0].z == colors[1][1][0].z ? (colors[0][1][1].z == colors[1][1][1].z ? PBLState.SOLVED : PBLState.ADJ) : (colors[0][1][1].z == colors[1][1][1].z || colors[0][1][0].x == colors[0][1][1].x || colors[1][1][0].x == colors[1][1][1].x ? PBLState.ADJ : PBLState.DIAG);
        PBLState bottomState = colors[0][0][0].z == colors[1][0][0].z ? (colors[0][0][1].z == colors[1][0][1].z ? PBLState.SOLVED : PBLState.ADJ) : (colors[0][0][1].z == colors[1][0][1].z || colors[0][0][0].x == colors[0][0][1].x || colors[1][0][0].x == colors[1][0][1].x ? PBLState.ADJ : PBLState.DIAG);
        if (topState == PBLState.ADJ && bottomState == PBLState.ADJ) {
            if (colors[0][1][0].x == colors[0][1][1].x) {
                algorithms.add(U);
                Move.makeMoves(cubeClone, U);
            } else if (colors[1][1][0].x == colors[1][1][1].x) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
            } else if (colors[0][1][1].z == colors[1][1][1].z) {
                algorithms.add(U2);
                Move.makeMoves(cubeClone, U2);
            }
            if (colors[0][0][0].x == colors[0][0][1].x) {
                algorithms.add(D_);
                Move.makeMoves(cubeClone, D_);
            } else if (colors[1][0][0].x == colors[1][0][1].x) {
                algorithms.add(D);
                Move.makeMoves(cubeClone, D);
            } else if (colors[0][0][1].z == colors[1][0][1].z) {
                algorithms.add(D2);
                Move.makeMoves(cubeClone, D2);
            }
            algorithms.add(PBL_ADJ_ADJ);
            Move.makeMoves(cubeClone, PBL_ADJ_ADJ);
        } else if (topState == PBLState.ADJ && bottomState == PBLState.DIAG) {
            if (colors[0][1][0].x == colors[0][1][1].x) {
                algorithms.add(U);
                Move.makeMoves(cubeClone, U);
            } else if (colors[1][1][0].x == colors[1][1][1].x) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
            } else if (colors[0][1][1].z == colors[1][1][1].z) {
                algorithms.add(U2);
                Move.makeMoves(cubeClone, U2);
            }
            algorithms.add(PBL_ADJ_DIAG);
            Move.makeMoves(cubeClone, PBL_ADJ_DIAG);
        } else if (topState == PBLState.DIAG && bottomState == PBLState.ADJ) {
            if (colors[0][0][0].x == colors[0][0][1].x) {
                algorithms.add(D_);
                Move.makeMoves(cubeClone, D_);
            } else if (colors[1][0][0].x == colors[1][0][1].x) {
                algorithms.add(D);
                Move.makeMoves(cubeClone, D);
            } else if (colors[0][0][1].z == colors[1][0][1].z) {
                algorithms.add(D2);
                Move.makeMoves(cubeClone, D2);
            }
            algorithms.add(PBL_DIAG_ADJ);
            Move.makeMoves(cubeClone, PBL_DIAG_ADJ);
        } else if (topState == PBLState.DIAG && bottomState == PBLState.DIAG) {
            algorithms.add(PBL_DIAG_DIAG);
            Move.makeMoves(cubeClone, PBL_DIAG_DIAG);
        } else if (topState == PBLState.ADJ && bottomState == PBLState.SOLVED) {
            if (colors[0][1][0].z == colors[1][1][0].z) {
                algorithms.add(U_);
                Move.makeMoves(cubeClone, U_);
            } else if (colors[1][1][0].x == colors[1][1][1].x) {
                algorithms.add(U2);
                Move.makeMoves(cubeClone, U2);
            } else if (colors[0][1][1].z == colors[1][1][1].z) {
                algorithms.add(U);
                Move.makeMoves(cubeClone, U);
            }
            algorithms.add(PBL_ADJ_U);
            Move.makeMoves(cubeClone, PBL_ADJ_U);
        } else if (topState == PBLState.SOLVED && bottomState == PBLState.ADJ) {
            if (colors[0][0][0].z == colors[1][0][0].z) {
                algorithms.add(D);
                Move.makeMoves(cubeClone, D);
            } else if (colors[1][0][0].x == colors[1][0][1].x) {
                algorithms.add(D2);
                Move.makeMoves(cubeClone, D2);
            } else if (colors[0][0][1].z == colors[1][0][1].z) {
                algorithms.add(D_);
                Move.makeMoves(cubeClone, D_);
            }
            algorithms.add(PBL_ADJ_D);
            Move.makeMoves(cubeClone, PBL_ADJ_D);
        } else if (topState == PBLState.DIAG && bottomState == PBLState.SOLVED) {
            algorithms.add(PBL_DIAG_U);
            Move.makeMoves(cubeClone, PBL_DIAG_U);
        } else if (topState == PBLState.SOLVED && bottomState == PBLState.DIAG) {
            algorithms.add(PBL_DIAG_D);
            Move.makeMoves(cubeClone, PBL_DIAG_D);
        }
        if (topState != PBLState.SOLVED || bottomState != PBLState.SOLVED) {
            EntropicEnumeratorBlockEntity.updateColors(cubeClone, colors);
        }
        if (colors[0][0][0].z == colors[0][1][1].x) {
            algorithms.add(U);
        } else if (colors[0][0][0].z == colors[1][1][0].x) {
            algorithms.add(U_);
        } else if (colors[0][0][0].z == colors[1][1][1].z) {
            algorithms.add(U2);
        }
        int moveCount = 0;
        for (Move[] algorithm : algorithms) {
            moveCount += algorithm.length;
        }
        this.moveQueue = new Move[moveCount];
        int moveIndex = 0;
        for (i = 0; i < algorithms.size(); ++i) {
            Move[] algorithm = (Move[])algorithms.get(i);
            for (int j = 0; j < algorithm.length; ++j) {
                this.moveQueue[moveIndex] = algorithm[j];
                ++moveIndex;
            }
        }
        if (fail && this.moveQueue.length > 0) {
            int wrongMove = seededRand.nextInt(this.moveQueue.length);
            Move[] wrongMoves = Move.getNextMoves(this.moveQueue[wrongMove]);
            this.moveQueue[wrongMove] = wrongMoves[seededRand.nextInt(wrongMoves.length)];
        }
        this.moveQueue = EntropicEnumeratorBlockEntity.optimizeAlgorithm(this.moveQueue);
        this.offsetQueue = new int[this.moveQueue.length];
        for (i = 0; i < this.moveQueue.length; ++i) {
            this.offsetQueue[i] = solvingMoveTime;
        }
        if (this.moveQueue.length > 0) {
            this.offsetQueue[0] = 0;
        }
        this.nextMoveTime = direct ? this.f_58857_.m_46467_() + (long)delay : this.f_58857_.m_46467_() + (long)delay + (long)seededRand.nextInt(solvingMoveTime) - (long)(this.moveQueue.length * solvingMoveTime);
        this.m_6596_();
    }

    public void restartScramble(int offset) {
        if (this.moveQueue.length > 0) {
            for (int i = 0; i < this.moveQueue.length; ++i) {
                this.moveQueue[i].makeMove(this.cube);
            }
        }
        this.moveQueue = new Move[0];
        this.offsetQueue = new int[0];
        this.solving = false;
        this.moveOffset = ((int)(this.f_58857_.m_46467_() % (long)queueTime) + offset) % queueTime;
        this.m_6596_();
    }

    public static Move[] optimizeAlgorithm(Move[] algorithm) {
        ArrayList<Move> newAlgorithm = new ArrayList<Move>();
        for (int i = 0; i < algorithm.length; ++i) {
            if (i == algorithm.length - 1) {
                newAlgorithm.add(algorithm[i]);
                break;
            }
            String current = algorithm[i].name();
            String next = algorithm[i + 1].name();
            if (current.charAt(0) == next.charAt(0)) {
                int nextMod;
                int currentMod = current.length() > 1 ? (int)current.charAt(1) : 32;
                int n = nextMod = next.length() > 1 ? (int)next.charAt(1) : 32;
                if (currentMod == 95 && nextMod == 95 || currentMod == 32 && nextMod == 32) {
                    newAlgorithm.add(Move.valueOf(current.charAt(0) + "2"));
                } else if (currentMod == 50 && nextMod == 95 || currentMod == 95 && nextMod == 50) {
                    newAlgorithm.add(Move.valueOf("" + current.charAt(0)));
                } else if (currentMod == 50 && nextMod == 32 || currentMod == 32 && nextMod == 50) {
                    newAlgorithm.add(Move.valueOf(current.charAt(0) + "_"));
                }
                ++i;
                continue;
            }
            newAlgorithm.add(algorithm[i]);
        }
        if (newAlgorithm.size() < algorithm.length) {
            return newAlgorithm.toArray(new Move[newAlgorithm.size()]);
        }
        return algorithm;
    }

    public boolean isSolved() {
        Cubie[][][] cubeClone = new Cubie[2][2][2];
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    cubeClone[x][y][z] = new Cubie(this.cube[x][y][z].basePosition, this.cube[x][y][z].baseColors, new Quaterniond((Quaterniondc)this.cube[x][y][z].rotation));
                }
            }
        }
        this.applyCurrentQueue(cubeClone);
        return EntropicEnumeratorBlockEntity.isSolved(cubeClone);
    }

    public static boolean isSolved(Cubie[][][] cube) {
        Vector3d[][][] colors = new Vector3d[2][2][2];
        EntropicEnumeratorBlockEntity.updateColors(cube, colors);
        double downCol = colors[0][0][0].y;
        double upCol = 7.0 - downCol;
        double northCol = colors[0][0][0].z;
        double southCol = 7.0 - northCol;
        double westCol = colors[0][0][0].x;
        double eastCol = 7.0 - westCol;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    if (y == 0 ? colors[x][y][z].y != downCol : colors[x][y][z].y != upCol) {
                        return false;
                    }
                    if (z == 0 ? colors[x][y][z].z != northCol : colors[x][y][z].z != southCol) {
                        return false;
                    }
                    if (!(x == 0 ? colors[x][y][z].x != westCol : colors[x][y][z].x != eastCol)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EntropicEnumeratorBlockEntity blockEntity) {
        if (blockEntity.solving) {
            return;
        }
        if (blockEntity.moveOffset == -1) {
            blockEntity.moveOffset = ((int)(level.m_46467_() % (long)queueTime) + 2) % queueTime;
            blockEntity.m_6596_();
        }
        if (level.m_46467_() % (long)queueTime == (long)blockEntity.moveOffset) {
            int i;
            Move lastMove = null;
            if (blockEntity.moveQueue.length > 0) {
                for (i = 0; i < blockEntity.moveQueue.length; ++i) {
                    blockEntity.moveQueue[i].makeMove(blockEntity.cube);
                }
                lastMove = blockEntity.moveQueue[blockEntity.moveQueue.length - 1];
            }
            blockEntity.nextMoveTime = level.m_46467_() + (long)(moveTime / 2);
            blockEntity.moveQueue = new Move[queueSize];
            blockEntity.offsetQueue = new int[queueSize];
            for (i = 0; i < queueSize; ++i) {
                Move[] nextMoves = Move.getNextMoves(lastMove);
                blockEntity.moveQueue[i] = nextMoves[Misc.random.nextInt(nextMoves.length)];
                blockEntity.offsetQueue[i] = moveTime;
                lastMove = blockEntity.moveQueue[i];
            }
            blockEntity.offsetQueue[0] = 0;
            blockEntity.m_6596_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level level, BlockPos pos, BlockState state, EntropicEnumeratorBlockEntity blockEntity) {
        if (level.m_46467_() >= blockEntity.nextMoveTime) {
            long turnTicks = level.m_46467_() - blockEntity.nextMoveTime;
            for (int i = 0; i < blockEntity.moveQueue.length; ++i) {
                if (turnTicks == (long)blockEntity.offsetQueue[i]) {
                    level.m_5594_((Player)Minecraft.m_91087_().f_91074_, pos, (SoundEvent)EmbersSounds.ENTROPIC_ENUMERATOR_TURN.get(), SoundSource.BLOCKS, blockEntity.solving ? 0.7f : 0.5f, blockEntity.solving ? 1.2f : 0.8f);
                    break;
                }
                if (turnTicks < (long)blockEntity.offsetQueue[i]) break;
                turnTicks -= (long)blockEntity.offsetQueue[i];
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!(this.f_58859_ || !this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61372_) && side != null || cap != EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY || side != null && side.m_122424_() != this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_))) {
            return this.upgrade.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.upgrade.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public static class Cubie {
        public static Vector3d zero = new Vector3d();
        public Vector3d basePosition;
        public Vector3d baseColors;
        public Quaterniond rotation;
        public Vector3d currentPosition = null;
        public Vector3d currentColors = null;

        public Cubie(Vector3d position, Vector3d colors, Quaterniond rotation) {
            this.basePosition = position;
            this.baseColors = colors;
            this.rotation = rotation;
        }

        public Cubie(Vector3d position, Vector3d colors) {
            this(position, colors, new Quaterniond());
        }

        public Cubie(Vector3d position, Quaterniond rotation) {
            this(position, zero, rotation);
        }

        public void setChanged() {
            this.currentPosition = null;
            this.currentColors = null;
        }

        public Vector3d getPos() {
            if (this.currentPosition != null) {
                return this.currentPosition;
            }
            this.currentPosition = this.rotation.transform((Vector3dc)this.basePosition, new Vector3d()).round();
            return this.currentPosition;
        }

        public Vector3d getColors() {
            if (this.currentColors != null) {
                return this.currentColors;
            }
            this.currentColors = this.rotation.transform((Vector3dc)this.baseColors, new Vector3d()).absolute().round();
            return this.currentColors;
        }
    }

    public static enum Move {
        U("U", new Vector3d(0.0, 1.0, 0.0), -0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        U_("U'", new Vector3d(0.0, 1.0, 0.0), 0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        U2("U2", new Vector3d(0.0, 1.0, 0.0), 1.0, 6, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        D("D", new Vector3d(0.0, 1.0, 0.0), 0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        D_("D'", new Vector3d(0.0, 1.0, 0.0), -0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        D2("D2", new Vector3d(0.0, 1.0, 0.0), 1.0, 6, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        L("L", new Vector3d(1.0, 0.0, 0.0), -0.5, 4, new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(1, -1, 1)),
        L_("L'", new Vector3d(1.0, 0.0, 0.0), 0.5, 4, new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(1, -1, 1)),
        L2("L2", new Vector3d(1.0, 0.0, 0.0), 1.0, 6, new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(1, -1, 1)),
        R("R", new Vector3d(1.0, 0.0, 0.0), 0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(-1, 1, -1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, 1)),
        R_("R'", new Vector3d(1.0, 0.0, 0.0), -0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(-1, 1, -1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, 1)),
        R2("R2", new Vector3d(1.0, 0.0, 0.0), 1.0, 6, new Vector3i(-1, -1, -1), new Vector3i(-1, 1, -1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, 1)),
        F("F", new Vector3d(0.0, 0.0, 1.0), 0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(-1, 1, -1)),
        F_("F'", new Vector3d(0.0, 0.0, 1.0), -0.5, 4, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(-1, 1, -1)),
        F2("F2", new Vector3d(0.0, 0.0, 1.0), 1.0, 6, new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, 1, -1), new Vector3i(-1, 1, -1)),
        B("B", new Vector3d(0.0, 0.0, 1.0), -0.5, 4, new Vector3i(-1, -1, 1), new Vector3i(1, -1, 1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        B_("B'", new Vector3d(0.0, 0.0, 1.0), 0.5, 4, new Vector3i(-1, -1, 1), new Vector3i(1, -1, 1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        B2("B2", new Vector3d(0.0, 0.0, 1.0), 1.0, 6, new Vector3i(-1, -1, 1), new Vector3i(1, -1, 1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1)),
        X("X", new Vector3d(1.0, 0.0, 0.0), 0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        X_("X'", new Vector3d(1.0, 0.0, 0.0), -0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        X2("X2", new Vector3d(1.0, 0.0, 0.0), 1.0, 6, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Y("Y", new Vector3d(0.0, 1.0, 0.0), 0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Y_("Y'", new Vector3d(0.0, 1.0, 0.0), -0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Y2("Y2", new Vector3d(0.0, 1.0, 0.0), 1.0, 6, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Z("Z", new Vector3d(0.0, 0.0, 1.0), 0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Z_("Z'", new Vector3d(0.0, 0.0, 1.0), -0.5, 4, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1)),
        Z2("Z2", new Vector3d(0.0, 0.0, 1.0), 1.0, 6, new Vector3i(-1, 1, -1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 1), new Vector3i(-1, 1, 1), new Vector3i(-1, -1, -1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 1), new Vector3i(-1, -1, 1));

        public static final Move[] axisMoves;
        public static final Move[] quarterMoves;
        public static final Move[] movesX;
        public static final Move[] movesY;
        public static final Move[] movesZ;
        public static final Move[] halfMoves;
        public static final Move[] movesX2;
        public static final Move[] movesY2;
        public static final Move[] movesZ2;
        public final String name;
        public final Vector3d axis;
        public final double angle;
        public final int length;
        public final Vector3i[] pieces;

        private Move(String name, Vector3d axis, double angle, int length, Vector3i ... pieces) {
            this.name = name;
            this.axis = axis;
            this.angle = angle * Math.PI;
            this.length = length;
            this.pieces = pieces;
        }

        public static void makeMoves(Cubie[][][] cubies, Move[] moves) {
            for (Move move : moves) {
                move.makeMove(cubies);
            }
        }

        public void makeMove(Cubie[][][] cubies) {
            ArrayList<Cubie> affectedCubies = new ArrayList<Cubie>();
            for (Vector3i pos : this.pieces) {
                for (int x = 0; x < 2; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        for (int z = 0; z < 2; ++z) {
                            Vector3d position = cubies[x][y][z].getPos();
                            if ((int)position.x != pos.x || (int)position.y != pos.y || (int)position.z != pos.z) continue;
                            affectedCubies.add(cubies[x][y][z]);
                        }
                    }
                }
            }
            for (Cubie cubie : affectedCubies) {
                cubie.setChanged();
                cubie.rotation.rotateAxis(this.angle, (Vector3dc)cubie.rotation.transformInverse((Vector3dc)this.axis, new Vector3d()));
            }
        }

        public Quaternionf makePartialMove(Quaternionf cubie, Vector3d position, float moveAmount) {
            for (Vector3i pos : this.pieces) {
                if ((int)position.x != pos.x || (int)position.y != pos.y || (int)position.z != pos.z) continue;
                Vector3d newAxis = cubie.transformInverse((Vector3dc)this.axis, new Vector3d());
                cubie.rotateAxis((float)this.angle * moveAmount, (float)newAxis.x(), (float)newAxis.y(), (float)newAxis.z());
            }
            return cubie;
        }

        public Move getOpposite() {
            switch (this) {
                case U: {
                    return U_;
                }
                case U_: {
                    return U;
                }
                case D: {
                    return D_;
                }
                case D_: {
                    return D;
                }
                case L: {
                    return L_;
                }
                case L_: {
                    return L;
                }
                case R: {
                    return R_;
                }
                case R_: {
                    return R;
                }
                case F: {
                    return F_;
                }
                case F_: {
                    return F;
                }
                case B: {
                    return B_;
                }
                case B_: {
                    return B;
                }
            }
            return U;
        }

        public static Move[] getNextMoves(Move move) {
            if (move == null) {
                return quarterMoves;
            }
            switch (move) {
                case L: 
                case L_: 
                case R: 
                case R_: {
                    return movesX;
                }
                case U: 
                case U_: 
                case D: 
                case D_: {
                    return movesY;
                }
                case F: 
                case F_: 
                case B: 
                case B_: {
                    return movesZ;
                }
                case L2: 
                case R2: {
                    return movesX2;
                }
                case U2: 
                case D2: {
                    return movesY2;
                }
                case F2: 
                case B2: {
                    return movesZ2;
                }
            }
            return quarterMoves;
        }

        public static Move[] getMoves(String algorithm) {
            String[] names = algorithm.split(" ");
            Move[] moves = new Move[names.length];
            for (int i = 0; i < names.length; ++i) {
                moves[i] = Move.valueOf(names[i]);
            }
            return moves;
        }

        static {
            axisMoves = new Move[]{X, X_, Y, Y_, Z, Z_};
            quarterMoves = new Move[]{U, U_, D, D_, L, L_, R, R_, F, F_, B, B_};
            movesX = new Move[]{U, U_, D, D_, F, F_, B, B_};
            movesY = new Move[]{L, L_, R, R_, F, F_, B, B_};
            movesZ = new Move[]{U, U_, D, D_, L, L_, R, R_};
            halfMoves = new Move[]{U2, D2, L2, R2, F2, B2};
            movesX2 = new Move[]{U2, D2, F2, B2};
            movesY2 = new Move[]{L2, R2, F2, B2};
            movesZ2 = new Move[]{U2, D2, L2, R2};
        }
    }

    public static enum PBLState {
        ADJ,
        DIAG,
        SOLVED;

    }
}

