/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.PressureRefineryTopBlockEntity;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.recipe.BlockStateContext;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.IMetalCoefficientRecipe;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.FluidHandlerBlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class PressureRefineryBottomBlockEntity
extends FluidHandlerBlockEntity
implements IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final float BASE_MULTIPLIER = 1.25f;
    public static final int FLUID_CONSUMED = 25;
    public static final float PER_BLOCK_MULTIPLIER = 0.25f;
    public static final int PROCESS_TIME = 20;
    public static int capacity = 8000;
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PressureRefineryBottomBlockEntity.this.m_6596_();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (Misc.getRecipe(PressureRefineryBottomBlockEntity.this.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), new SingleItemContainer(stack), PressureRefineryBottomBlockEntity.this.f_58857_) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public IEmberActivationRecipe cachedRecipe = null;
    public IMetalCoefficientRecipe cachedCoefficient = null;

    public PressureRefineryBottomBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.PRESSURE_REFINERY_BOTTOM_ENTITY.get(), pPos, pBlockState);
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                PressureRefineryBottomBlockEntity.this.m_6596_();
            }
        };
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("progress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("progress", this.progress);
    }

    public double getMultiplier() {
        BlockState metalState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        BlockStateContext context = new BlockStateContext(metalState);
        this.cachedCoefficient = Misc.getRecipe(this.cachedCoefficient, (RecipeType)RegistryManager.METAL_COEFFICIENT.get(), context, this.f_58857_);
        double metalMultiplier = this.cachedCoefficient == null ? 1.25 : this.cachedCoefficient.getCoefficient(context) - 1.25;
        double totalMult = 1.25;
        if (this.cachedCoefficient == null) {
            totalMult = metalMultiplier;
        } else {
            for (Direction facing : Misc.horizontals) {
                if (!this.f_58857_.m_8055_(this.f_58858_.m_7495_().m_121945_(facing)).m_204336_(EmbersBlockTags.HEAT_SOURCES)) continue;
                totalMult += 0.25 * metalMultiplier;
            }
        }
        return totalMult;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, PressureRefineryBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades((BlockEntity)blockEntity, blockEntity.upgrades);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PressureRefineryBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades((BlockEntity)blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick((BlockEntity)blockEntity, blockEntity.upgrades)) {
            return;
        }
        if (!blockEntity.inventory.getStackInSlot(0).m_41619_()) {
            boolean cancel;
            BlockEntity tile = level.m_7702_(pos.m_7494_());
            if (blockEntity.tank.getFluid() != null && blockEntity.tank.getFluid().getFluid().m_205067_(FluidTags.f_13131_) && blockEntity.tank.getFluidAmount() >= 25 && !(cancel = UpgradeUtil.doWork((BlockEntity)blockEntity, blockEntity.upgrades)) && tile instanceof PressureRefineryTopBlockEntity) {
                PressureRefineryTopBlockEntity top = (PressureRefineryTopBlockEntity)tile;
                ++blockEntity.progress;
                if (blockEntity.progress > UpgradeUtil.getWorkTime((BlockEntity)blockEntity, 20, blockEntity.upgrades)) {
                    blockEntity.progress = 0;
                    if (blockEntity.inventory != null) {
                        double emberValue;
                        double ember;
                        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)blockEntity.inventory);
                        blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), wrapper, level);
                        if (blockEntity.cachedRecipe != null && ((ember = UpgradeUtil.getTotalEmberProduction((BlockEntity)blockEntity, emberValue = (double)blockEntity.cachedRecipe.getOutput((Container)wrapper) * blockEntity.getMultiplier(), blockEntity.upgrades)) > 0.0 || emberValue == 0.0) && top.capability.getEmber() + ember <= top.capability.getEmberCapacity()) {
                            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.PRESSURE_REFINERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverLevel.m_8767_((ParticleOptions)new GlowParticleOptions(EmbersColors.EMBER_ID, new Vec3(0.0, (double)0.65f, 0.0), 4.7f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.5f), (double)((float)pos.m_123343_() + 0.5f), 80, 0.1, 0.1, 0.1, 1.0);
                                serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(EmbersColors.SMOKE_ID, 5.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 20, 0.1, 0.1, 0.1, 1.0);
                            }
                            UpgradeUtil.throwEvent((BlockEntity)blockEntity, new EmberEvent((BlockEntity)blockEntity, EmberEvent.EnumType.PRODUCE, ember), blockEntity.upgrades);
                            top.capability.addAmount(ember, true);
                            blockEntity.cachedRecipe.process((Container)wrapper);
                            blockEntity.tank.drain(25, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
                blockEntity.m_6596_();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        if ("ember".equals(dialType)) {
            DecimalFormat multiplierFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = this.getMultiplier();
            information.add((Component)Component.m_237110_((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
        UpgradeUtil.throwEvent((BlockEntity)this, new DialInformationEvent((BlockEntity)this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember")));
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", (Component)Component.m_237115_((String)"embers.tooltip.goggles.fluid.water")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

