/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.rekindled.embers.blockentity.FluidVesselBlockEntity;
import com.rekindled.embers.render.FluidCuboid;
import com.rekindled.embers.render.FluidRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Vector3f;

public class FluidVesselBlockEntityRenderer
implements BlockEntityRenderer<FluidVesselBlockEntity> {
    FluidCuboid cube = new FluidCuboid(new Vector3f(4.0f, 2.0f, 4.0f), new Vector3f(12.0f, 15.0f, 12.0f), FluidCuboid.DEFAULT_FACES);

    public FluidVesselBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(FluidVesselBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity != null) {
            FluidStack fluidStack = blockEntity.getFluidStack();
            int capacity = blockEntity.getCapacity();
            if (!fluidStack.isEmpty() && capacity > 0) {
                float offset = blockEntity.renderOffset;
                if (offset > 1.2f || offset < -1.2f) {
                    offset -= (offset / 12.0f + 0.1f) * partialTick;
                    blockEntity.renderOffset = offset;
                } else {
                    blockEntity.renderOffset = 0.0f;
                }
                FluidRenderer.renderScaledCuboid(poseStack, bufferSource, this.cube, fluidStack, offset, capacity, packedLight, packedOverlay, false);
            } else {
                blockEntity.renderOffset = 0.0f;
            }
        }
    }
}

