/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.entity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.GlimmerBlock;
import com.rekindled.embers.entity.EmberProjectileEntity;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GlimmerProjectileEntity
extends Projectile {
    public static final GlowParticleOptions EMBER = new GlowParticleOptions(EmbersColors.EMBER_ID, new Vec3(0.0, 1.0E-6, 0.0), 3.0f, 120);
    public static final SparkParticleOptions GLIMMER = new SparkParticleOptions(EmbersColors.GLIMMER_PROJECTILE_ID, 1.5f);
    public static final SmokeParticleOptions SMOKE = new SmokeParticleOptions(EmbersColors.SMOKE_ID, 6.0f);
    public static final EntityDataAccessor<Integer> lifetime = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GlimmerProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(lifetime, (Object)160);
    }

    public void m_37251_(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        this.m_5602_(shooter);
        super.m_6686_((double)x, (double)y, (double)z, velocity, inaccuracy);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public void m_8119_() {
        super.m_8119_();
        int lifetime = (Integer)this.m_20088_().m_135370_(GlimmerProjectileEntity.lifetime);
        this.m_20088_().m_135381_(GlimmerProjectileEntity.lifetime, (Object)(lifetime - 1));
        if (lifetime <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 oldPosition = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 newPosVector = oldPosition.m_82549_(this.m_20184_());
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(oldPosition, newPosVector.m_82549_(this.m_20184_().m_82541_().m_82490_(1.5)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
            newPosVector = raytraceresult.m_82450_();
        }
        this.m_6478_(MoverType.SELF, newPosVector.m_82546_(oldPosition));
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.05f, 0.0));
        if (!this.m_9236_().m_5776_() && raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
        }
        if (this.m_9236_().m_5776_()) {
            double deltaX = this.m_20185_() - oldPosition.f_82479_;
            double deltaY = this.m_20186_() - oldPosition.f_82480_;
            double deltaZ = this.m_20189_() - oldPosition.f_82481_;
            for (double i = 0.0; i < 9.0; i += 1.0) {
                double coeff = i / 9.0;
                this.m_9236_().m_7106_((ParticleOptions)GLIMMER, oldPosition.f_82479_ + deltaX * coeff, oldPosition.f_82480_ + deltaY * coeff, oldPosition.f_82481_ + deltaZ * coeff, (double)(1.1f * (Misc.random.nextFloat() - 0.5f)), (double)(1.1f * (Misc.random.nextFloat() - 0.5f)), (double)(1.1f * (Misc.random.nextFloat() - 0.5f)));
            }
        }
    }

    public void m_8060_(BlockHitResult raytraceresult) {
        super.m_8060_(raytraceresult);
        Direction side = raytraceresult.m_82434_();
        BlockPos hitPos = raytraceresult.m_82425_().m_121945_(side);
        BlockPlaceContext context = new BlockPlaceContext(this.m_9236_(), this.m_19749_() instanceof Player ? (Player)this.m_19749_() : null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, raytraceresult);
        if (this.m_9236_().m_8055_(hitPos).m_60629_(context)) {
            this.m_9236_().m_7731_(hitPos, ((Block)RegistryManager.GLIMMER.get()).m_5573_(context), 11);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)GlimmerBlock.GLIMMER, (double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.5, (double)hitPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)EMBER, (double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.5, (double)hitPos.m_123343_() + 0.5, 1, 0.0, 0.001, 0.0, 0.0);
            }
        } else {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)SMOKE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

