/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.render.SneakyBufferSourceWrapper;
import com.rekindled.embers.research.ResearchBase;
import com.rekindled.embers.research.ResearchCategory;
import com.rekindled.embers.research.ResearchManager;
import com.rekindled.embers.research.subtypes.ResearchSwitchCategory;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.RenderUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GuiCodex
extends Screen {
    public double mouseX = 0.0;
    public double mouseY = 0.0;
    public double smoothMouseX = 0.0;
    public double smoothMouseY = 0.0;
    public int selectedIndex = -1;
    public int selectedPageIndex = -1;
    public ResearchCategory researchCategory;
    public ResearchBase researchPage;
    public Screen previousScreen;
    public float ticks = 1.0f;
    public boolean showLeftArrow = false;
    public boolean showRightArrow = false;
    public int tooltipX = 0;
    public int tooltipY = 0;
    ItemStack tooltipStack = null;
    public boolean renderTooltip = false;
    public int framesExisted = 0;
    public float[] raise = null;
    public float[] raiseTargets = null;
    public String[] sentences = null;
    LinkedList<ResearchCategory> lastCategories = new LinkedList();
    public boolean nextPageSelected;
    public boolean previousPageSelected;
    public String searchString = "";
    public int searchDelay;
    public ArrayList<ResearchBase> searchResult = new ArrayList();
    public static ResourceLocation INDEX = new ResourceLocation("embers", "textures/gui/codex_index.png");
    public static ResourceLocation PARTS = new ResourceLocation("embers", "textures/gui/codex_parts.png");
    public static int codexWidth = 192;
    public static int codexHeight = 240;
    public static int categoryWidth = 384;
    public static int categoryHeight = 246;
    public static float categorySpacingY = 0.925f;
    public static int pageWidth = 208;
    public static int pageHeight = 240;
    public static GuiCodex instance = new GuiCodex();

    public GuiCodex() {
        super((Component)Component.m_237115_((String)"gui.embers.codex.title"));
    }

    public void markTooltipForRender(ItemStack stack, int x, int y) {
        this.renderTooltip = true;
        this.tooltipX = x;
        this.tooltipY = y;
        this.tooltipStack = stack;
    }

    public void doRenderTooltip(GuiGraphics graphics) {
        if (this.renderTooltip) {
            graphics.m_280153_(this.f_96547_, this.tooltipStack, this.tooltipX, this.tooltipY);
            this.renderTooltip = false;
        }
    }

    public void pushLastCategory(ResearchCategory category) {
        ListIterator iterator = this.lastCategories.listIterator();
        boolean clear = false;
        while (iterator.hasNext()) {
            ResearchCategory lastCategory = (ResearchCategory)iterator.next();
            if (lastCategory == category) {
                clear = true;
            }
            if (!clear) continue;
            iterator.remove();
        }
        this.lastCategories.add(category);
    }

    public ResearchCategory popLastCategory() {
        if (this.lastCategories.isEmpty()) {
            return null;
        }
        return this.lastCategories.removeLast();
    }

    public ResearchCategory peekLastCategory() {
        if (this.lastCategories.isEmpty()) {
            return null;
        }
        return this.lastCategories.getLast();
    }

    public void renderItemStackAt(GuiGraphics graphics, ItemStack stack, int x, int y, int mouseX, int mouseY) {
        if (!stack.m_41619_()) {
            graphics.m_280203_(stack, x, y);
            graphics.m_280302_(this.f_96547_, stack, x, y, stack.m_41613_() != 1 ? Integer.toString(stack.m_41613_()) : "");
            if (mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
                this.markTooltipForRender(stack, mouseX, mouseY);
            }
        }
    }

    public void renderItemStackMinusTooltipAt(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (!stack.m_41619_()) {
            graphics.m_280203_(stack, x, y);
            RenderSystem.enableBlend();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && (this.researchCategory != null || this.researchPage != null)) {
            if (this.researchPage != null) {
                this.researchPage = null;
                this.playSound((SoundEvent)EmbersSounds.CODEX_PAGE_CLOSE.get());
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
            this.researchCategory = this.popLastCategory();
            this.playSound(this.researchCategory == null ? (SoundEvent)EmbersSounds.CODEX_CATEGORY_CLOSE.get() : (SoundEvent)EmbersSounds.CODEX_CATEGORY_SWITCH.get());
            return false;
        }
        if (this.researchPage != null && this.researchPage.hasMultiplePages()) {
            if (Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode)) {
                this.switchPreviousPage();
                return false;
            }
            if (Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode)) {
                this.switchNextPage();
                return false;
            }
        } else if (this.researchPage == null && keyCode == 259 && !this.searchString.isEmpty()) {
            this.setSearchString(this.searchString.substring(0, this.searchString.length() - 1));
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return this.researchCategory == null;
    }

    public boolean m_5534_(char typedChar, int modifiers) {
        if (this.researchPage == null && !Character.isISOControl(typedChar)) {
            this.setSearchString(this.searchString + typedChar);
        }
        return super.m_5534_(typedChar, modifiers);
    }

    private void setSearchString(String string) {
        this.searchString = string;
        this.searchDelay = 20;
    }

    private void switchNextPage() {
        this.researchPage = this.researchPage.getNextPage();
        this.playSound((SoundEvent)EmbersSounds.CODEX_PAGE_SWITCH.get());
    }

    private void switchPreviousPage() {
        this.researchPage = this.researchPage.getPreviousPage();
        this.playSound((SoundEvent)EmbersSounds.CODEX_PAGE_SWITCH.get());
    }

    public void playSound(SoundEvent sound) {
        this.playSound(sound, 0.75f);
    }

    public void playSound(SoundEvent sound, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)1.0f));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ResearchCategory selectedCategory;
        if (this.selectedIndex != -1 && this.researchCategory == null && (selectedCategory = ResearchManager.researches.get(this.selectedIndex)).isChecked()) {
            this.researchCategory = selectedCategory;
            this.playSound((SoundEvent)EmbersSounds.CODEX_CATEGORY_OPEN.get());
        }
        if (this.selectedPageIndex != -1 && this.researchPage == null) {
            ResearchBase selectedResearchPage = this.researchCategory.researches.get(this.selectedPageIndex);
            if (mouseButton == 0) {
                if (selectedResearchPage.onOpen(this)) {
                    this.researchPage = selectedResearchPage;
                    this.playSound((SoundEvent)EmbersSounds.CODEX_PAGE_OPEN.get());
                }
            } else if (mouseButton == 1) {
                boolean newChecked = !selectedResearchPage.isChecked();
                selectedResearchPage.check(newChecked);
                if (newChecked) {
                    this.playSound((SoundEvent)EmbersSounds.CODEX_CHECK.get());
                } else {
                    this.playSound((SoundEvent)EmbersSounds.CODEX_UNCHECK.get());
                }
                if (selectedResearchPage instanceof ResearchSwitchCategory) {
                    ResearchSwitchCategory selectedCategory2 = (ResearchSwitchCategory)selectedResearchPage;
                    for (ResearchBase research : selectedCategory2.targetCategory.researches) {
                        ResearchManager.sendCheckmark(research, newChecked);
                    }
                } else {
                    ResearchManager.sendCheckmark(selectedResearchPage, newChecked);
                }
            }
        }
        if (this.researchPage != null && this.researchPage.hasMultiplePages()) {
            if (this.nextPageSelected) {
                this.switchNextPage();
            } else if (this.previousPageSelected) {
                this.switchPreviousPage();
            }
        }
        return false;
    }

    public static void drawText(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y, int color) {
        int shadowColor = Misc.intColor(64, 0, 0, 0);
        graphics.m_280649_(font, s, x - 1, y, shadowColor, false);
        graphics.m_280649_(font, s, x + 1, y, shadowColor, false);
        graphics.m_280649_(font, s, x, y - 1, shadowColor, false);
        graphics.m_280649_(font, s, x, y + 1, shadowColor, false);
        graphics.m_280649_(font, s, x, y, color, false);
    }

    public static void drawTextGlowing(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y) {
        int shadowColor = Misc.intColor(64, 0, 0, 0);
        graphics.m_280649_(font, s, x - 1, y, shadowColor, false);
        graphics.m_280649_(font, s, x + 1, y, shadowColor, false);
        graphics.m_280649_(font, s, x, y - 1, shadowColor, false);
        graphics.m_280649_(font, s, x, y + 1, shadowColor, false);
        int shadowColor2 = Misc.intColor(40, 0, 0, 0);
        graphics.m_280649_(font, s, x - 2, y, shadowColor2, false);
        graphics.m_280649_(font, s, x + 2, y, shadowColor2, false);
        graphics.m_280649_(font, s, x, y - 2, shadowColor2, false);
        graphics.m_280649_(font, s, x, y + 2, shadowColor2, false);
        graphics.m_280649_(font, s, x - 1, y + 1, shadowColor2, false);
        graphics.m_280649_(font, s, x + 1, y - 1, shadowColor2, false);
        graphics.m_280649_(font, s, x - 1, y - 1, shadowColor2, false);
        graphics.m_280649_(font, s, x + 1, y + 1, shadowColor2, false);
        graphics.m_280649_(font, s, x, y, Misc.intColor(1.0f, Misc.multColor(EmbersColors.EMBER, 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f))), false);
    }

    public void drawModalRectGlowing(GuiGraphics graphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2509804f);
        graphics.m_280218_(texture, x - 1, y, textureX, textureY, width, height);
        graphics.m_280218_(texture, x + 1, y, textureX, textureY, width, height);
        graphics.m_280218_(texture, x, y - 1, textureX, textureY, width, height);
        graphics.m_280218_(texture, x, y + 1, textureX, textureY, width, height);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15686275f);
        graphics.m_280218_(texture, x - 2, y, textureX, textureY, width, height);
        graphics.m_280218_(texture, x + 2, y, textureX, textureY, width, height);
        graphics.m_280218_(texture, x, y - 2, textureX, textureY, width, height);
        graphics.m_280218_(texture, x, y + 2, textureX, textureY, width, height);
        graphics.m_280218_(texture, x - 1, y + 1, textureX, textureY, width, height);
        graphics.m_280218_(texture, x + 1, y - 1, textureX, textureY, width, height);
        graphics.m_280218_(texture, x - 1, y - 1, textureX, textureY, width, height);
        graphics.m_280218_(texture, x + 1, y + 1, textureX, textureY, width, height);
        Vector3f color = Misc.multColor(EmbersColors.EMBER, 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f));
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)1.0f);
        graphics.m_280218_(texture, x, y, textureX, textureY, width, height);
    }

    public static void drawTextGlowingAura(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f);
        GuiCodex.drawTextGlowingAura(font, graphics, s, x, y, sine);
    }

    public static void drawTextGlowingAura(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y, float mul) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        SneakyBufferSourceWrapper buffer = new SneakyBufferSourceWrapper((MultiBufferSource)graphics.m_280091_());
        int shadowColor = Misc.intColor(Mth.m_14036_((float)(0.15686f * mul), (float)0.15686f, (float)1.0f), Misc.multColor(EmbersColors.EMBER, mul));
        font.m_272191_(s, (float)(x - 1), (float)y, shadowColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x - 1), (float)y, shadowColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x + 1), (float)y, shadowColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)x, (float)(y - 1), shadowColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)x, (float)(y + 1), shadowColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        int shadowColor2 = Misc.intColor(Mth.m_14036_((float)(0.15686f * mul), (float)0.15686f, (float)1.0f), Misc.multColor(EmbersColors.EMBER.mul(0.5f, new Vector3f()), mul));
        font.m_272191_(s, (float)(x - 2), (float)y, shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x + 2), (float)y, shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)x, (float)(y - 2), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)x, (float)(y + 2), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x - 1), (float)(y + 1), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x + 1), (float)(y - 1), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x - 1), (float)(y - 1), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)(x + 1), (float)(y + 1), shadowColor2, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272191_(s, (float)x, (float)y, Misc.intColor(1.0f, Misc.multColor(EmbersColors.EMBER, mul)), false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawCenteredText(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y, int color) {
        GuiCodex.drawText(font, graphics, s, x - font.m_92724_(s) / 2, y, color);
    }

    public static void drawCenteredTextGlowing(Font font, GuiGraphics graphics, FormattedCharSequence s, int x, int y) {
        GuiCodex.drawTextGlowing(font, graphics, s, x - font.m_92724_(s) / 2, y);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        boolean showTooltips = true;
        boolean showSearchString = this.searchDelay >= 0 && !this.searchString.isEmpty();
        boolean doUpdateSynced = this.ticks > partialTicks;
        this.ticks = partialTicks;
        int numResearches = ResearchManager.researches.size();
        if (this.raise == null) {
            this.raise = new float[numResearches];
            for (i = 0; i < this.raise.length; ++i) {
                this.raise[i] = 0.0f;
            }
        }
        if (this.raiseTargets == null) {
            this.raiseTargets = new float[numResearches];
            for (i = 0; i < this.raiseTargets.length; ++i) {
                this.raiseTargets[i] = 0.0f;
            }
        }
        this.m_280273_(graphics);
        RenderSystem.enableBlend();
        int basePosX = (int)((float)this.f_96543_ / 2.0f) - 96;
        int basePosY = (int)((float)this.f_96544_ / 2.0f) - 128;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int lastSelectedIndex = this.selectedIndex;
        this.selectedIndex = -1;
        this.selectedPageIndex = -1;
        if (this.researchCategory == null && this.researchPage == null) {
            float i2;
            graphics.m_280218_(INDEX, basePosX, basePosY += 8, 0, 0, codexWidth, codexHeight);
            graphics.m_280218_(PARTS, basePosX - 16, basePosY - 16, 0, 0, 48, 48);
            graphics.m_280218_(PARTS, basePosX + 160, basePosY - 16, 48, 0, 48, 48);
            graphics.m_280218_(PARTS, basePosX + 160, basePosY + codexHeight - 32, 96, 0, 48, 48);
            graphics.m_280218_(PARTS, basePosX - 16, basePosY + codexHeight - 32, 144, 0, 48, 48);
            graphics.m_280218_(PARTS, basePosX + 72, basePosY - 16, 0, 48, 48, 48);
            graphics.m_280218_(PARTS, basePosX + 72, basePosY + codexHeight - 32, 0, 48, 48, 48);
            graphics.m_280218_(PARTS, basePosX - 16, basePosY + 64, 0, 48, 48, 48);
            graphics.m_280218_(PARTS, basePosX + 160, basePosY + 64, 0, 48, 48, 48);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float sine = 0.5f + 0.25f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f);
            RenderSystem.setShaderColor((float)EmbersColors.EMBER.x, (float)EmbersColors.EMBER.y, (float)EmbersColors.EMBER.z, (float)sine);
            for (i2 = 0.0f; i2 < 4.0f; i2 += 1.0f) {
                graphics.m_280218_(PARTS, basePosX - 16, basePosY + 208, 192, 0, 48, 48);
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i2 = 0.0f; i2 < (float)numResearches; i2 += 1.0f) {
                float mouseDir = (float)Math.toDegrees(Math.atan2(mouseY - (basePosY + 88), mouseX - (basePosX + 96))) + 90.0f;
                float distSq = (mouseX - (basePosX + 96)) * (mouseX - (basePosX + 96)) + (mouseY - (basePosY + 96)) * (mouseY - (basePosY + 96));
                float angle = i2 * (360.0f / (float)numResearches);
                boolean selected = false;
                float diff = Math.min(Math.min(Math.abs(mouseDir - angle), Math.abs(mouseDir - 360.0f - angle)), Math.abs(mouseDir + 360.0f) - angle);
                ResearchCategory category = ResearchManager.researches.get((int)i2);
                boolean alreadyGlowing = category.researches.stream().anyMatch(entry -> this.searchResult.contains(entry));
                if (diff < 180.0f / (float)numResearches && distSq < 16000.0f) {
                    if (lastSelectedIndex != (int)i2) {
                        if (category.isChecked() && !alreadyGlowing) {
                            this.playSound((SoundEvent)EmbersSounds.CODEX_CATEGORY_SELECT.get());
                        } else {
                            this.playSound((SoundEvent)EmbersSounds.CODEX_CATEGORY_UNSELECT.get());
                        }
                    }
                    selected = true;
                    this.selectedIndex = (int)i2;
                    if (this.raise[(int)i2] < 1.0f && doUpdateSynced) {
                        this.raise[(int)i2] = this.raiseTargets[(int)i2];
                        this.raiseTargets[(int)i2] = this.raiseTargets[(int)i2] * 0.5f + 0.5f;
                    }
                } else {
                    if (lastSelectedIndex == (int)i2) {
                        this.playSound((SoundEvent)EmbersSounds.CODEX_CATEGORY_UNSELECT.get());
                    }
                    if (doUpdateSynced) {
                        this.raise[(int)i2] = this.raiseTargets[(int)i2];
                        this.raiseTargets[(int)i2] = this.raiseTargets[(int)i2] * 0.5f;
                    }
                }
                float instRaise = this.raise[(int)i2] * (1.0f - partialTicks) + this.raiseTargets[(int)i2] * partialTicks;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(basePosX + 96), (float)(basePosY + 88), 0.0f);
                graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(angle));
                boolean glowing = alreadyGlowing || selected && category.isChecked();
                graphics.m_280218_(category.getIndexTexture(), -16, Math.round(-88.0f - 12.0f * instRaise), 192, 112, 32, 64);
                graphics.m_280218_(category.getIndexTexture(), -6, Math.round(-80.0f - 12.0f * instRaise), (int)category.getIconU() + (glowing ? 16 : 0), (int)category.getIconV(), 12, 12);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280218_(INDEX, basePosX + 64, basePosY + 56, 192, 176, 64, 64);
            if (!showSearchString && this.selectedIndex >= 0) {
                ResearchCategory category = ResearchManager.researches.get(this.selectedIndex);
                GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237113_((String)category.getName()).m_7532_(), basePosX + 96, basePosY + codexHeight - 49);
            } else if (!this.searchString.isEmpty()) {
                GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237113_((String)this.getSearchStringPrint()).m_7532_(), basePosX + 96, basePosY + codexHeight - 49);
            } else {
                GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237115_((String)"embers.research.null").m_7532_(), basePosX + 96, basePosY + codexHeight - 49);
            }
            if (this.selectedIndex >= 0) {
                ResearchCategory category = ResearchManager.researches.get(this.selectedIndex);
                List<Component> tooltip = category.getTooltip(showTooltips);
                if (!tooltip.isEmpty()) {
                    this.renderEmberTooltip(graphics, tooltip, mouseX, mouseY);
                }
            } else if (mouseX > basePosX - 16 && mouseY > basePosY + 224 && mouseX < basePosX - 16 + 48 && mouseY < basePosY + 224 + 48) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                for (String line : I18n.m_118938_((String)"embers.research.controls", (Object[])new Object[0]).split(";")) {
                    tooltip.add((Component)Component.m_237113_((String)line));
                }
                this.renderEmberTooltip(graphics, tooltip, mouseX, mouseY);
            }
        } else if (this.researchPage == null) {
            ResearchBase page;
            List<Component> tooltip;
            ResearchBase r;
            int i3;
            float showSpeed = 0.3f;
            boolean playUnlockSound = false;
            boolean playLockSound = false;
            basePosX = (int)((float)this.f_96543_ / 2.0f) - 192;
            basePosY = (int)((float)this.f_96544_ / 2.0f) - 136;
            graphics.m_280398_(this.researchCategory.getBackgroundTexture(), basePosX, basePosY + 12, 0, 0.0f, 0.0f, categoryWidth, categoryHeight, 512, 512);
            for (i3 = 0; i3 < this.researchCategory.researches.size(); ++i3) {
                float y;
                float x;
                BufferBuilder b;
                boolean isShown;
                r = this.researchCategory.researches.get(i3);
                if (r.isHidden()) continue;
                r.shownAmount = r.shownTarget;
                if (r.areAncestorsChecked()) {
                    if (r.shownTarget <= 0.0f) {
                        playUnlockSound = true;
                    }
                    r.shownTarget = Math.min(1.0f, r.shownTarget + partialTicks * 0.1f * showSpeed);
                } else {
                    if (r.shownTarget >= 1.0f) {
                        playLockSound = true;
                    }
                    r.shownTarget = Math.max(0.0f, r.shownTarget - partialTicks * 0.1f * showSpeed);
                }
                boolean bl = isShown = (double)r.shownAmount >= 1.0;
                if (isShown && mouseX >= basePosX + r.x - 24 && mouseY >= basePosY + r.y - 24 && mouseX <= basePosX + r.x + 24 && mouseY <= basePosY + r.y + 24) {
                    this.selectedPageIndex = i3;
                    if (r.selectedAmount < 1.0f) {
                        r.selectedAmount = r.selectionTarget;
                        r.selectionTarget = r.selectionTarget * (1.0f - partialTicks) + (r.selectionTarget * 0.8f + 0.2f) * partialTicks;
                    }
                } else if (r.selectedAmount > 0.0f) {
                    r.selectedAmount = r.selectionTarget;
                    r.selectionTarget = r.selectionTarget * (1.0f - partialTicks) + r.selectionTarget * 0.9f * partialTicks;
                }
                if (isShown && (this.searchResult.contains(r) || ResearchManager.isPathToLock(r) && this.searchResult.isEmpty())) {
                    Tesselator tess = Tesselator.m_85913_();
                    b = tess.m_85915_();
                    x = r.x;
                    y = (float)(r.y + 8) * categorySpacingY;
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    int index = this.searchResult.indexOf(r);
                    float amt = (float)Mth.m_14045_((int)(-this.searchDelay), (int)0, (int)10) / 10.0f;
                    amt = (float)((double)amt * Mth.m_14085_((double)0.5, (double)1.0, (double)((float)(this.searchResult.size() - index) / (float)this.searchResult.size())));
                    for (float j = 0.0f; j < 3.0f; j += 1.0f) {
                        float coeff = (j + 1.0f) / 3.0f;
                        b.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
                        RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt);
                        tess.m_85914_();
                    }
                    RenderSystem.defaultBlendFunc();
                }
                if (isShown && r.selectedAmount > 0.1f) {
                    Tesselator tess = Tesselator.m_85913_();
                    b = tess.m_85915_();
                    x = r.x;
                    y = (float)(r.y + 8) * categorySpacingY;
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    float amt = r.selectedAmount;
                    for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                        float coeff = (j + 1.0f) / 8.0f;
                        b.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
                        RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt);
                        tess.m_85914_();
                    }
                    RenderSystem.defaultBlendFunc();
                }
                if (r.ancestors.size() <= 0) continue;
                for (int l = 0; l < r.ancestors.size(); ++l) {
                    Tesselator tess = Tesselator.m_85913_();
                    BufferBuilder b2 = tess.m_85915_();
                    ResearchBase ancestor = r.ancestors.get(l);
                    float x1 = r.x;
                    float y1 = r.y;
                    float x2 = ancestor.x;
                    float y2 = ancestor.y;
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                        float coeff = (float)Math.pow((j + 1.0f) / 8.0f, 1.5);
                        float appearCoeff = Math.min(r.shownAmount, ancestor.shownAmount);
                        b2.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                        RenderUtil.renderWavyEmberLine(b2, (float)basePosX + x1, (float)basePosY + y1, (float)basePosX + x2, (float)basePosY + y2, 4.0f * coeff, appearCoeff, EmbersColors.EMBER);
                        tess.m_85914_();
                    }
                    RenderSystem.defaultBlendFunc();
                }
            }
            for (i3 = 0; i3 < this.researchCategory.researches.size(); ++i3) {
                r = this.researchCategory.researches.get(i3);
                if (r.isHidden() || !((double)r.shownAmount > 0.5)) continue;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)r.getIconBackground());
                int u = (int)r.getIconBackgroundU();
                int v = (int)r.getIconBackgroundV();
                graphics.m_280398_(r.getIconBackground(), basePosX + r.x - 24, basePosY + (int)((float)(r.y - 16) * categorySpacingY), 0, (float)u, (float)v, 48, 48, 512, 512);
                if (!r.isChecked()) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResearchManager.PAGE_ICONS);
                    int uOverlay = 240;
                    boolean vOverlay = false;
                    graphics.m_280398_(r.getIconBackground(), basePosX + r.x - 24, basePosY + (int)((float)(r.y - 16) * categorySpacingY), 0, (float)uOverlay, (float)vOverlay, 48, 48, 512, 512);
                }
                this.renderItemStackMinusTooltipAt(graphics, r.getIcon(), basePosX + r.x - 8, basePosY + (int)((float)(r.y - 16) * categorySpacingY) + 16);
            }
            if (!showSearchString && this.selectedPageIndex >= 0) {
                ResearchBase research = this.researchCategory.researches.get(this.selectedPageIndex);
                GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237113_((String)research.getName()).m_7532_(), basePosX + 192, basePosY + categoryHeight - 7);
            } else if (!this.searchString.isEmpty()) {
                GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237113_((String)this.getSearchStringPrint()).m_7532_(), basePosX + 192, basePosY + categoryHeight - 7);
            }
            for (int i4 = 0; i4 < this.researchCategory.researches.size(); ++i4) {
                r = this.researchCategory.researches.get(i4);
                if (r.isHidden() || !((double)r.shownAmount > 0.0) || !(r.shownAmount < 1.0f)) continue;
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder b = tess.m_85915_();
                float x = r.x;
                float y = (float)(r.y + 8) * categorySpacingY;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.setShader(GameRenderer::m_172811_);
                float amt = (float)Math.sin((double)r.shownAmount * Math.PI);
                for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                    float coeff = (j + 1.0f) / 8.0f;
                    b.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
                    RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt);
                    tess.m_85914_();
                }
                RenderSystem.defaultBlendFunc();
            }
            if (this.selectedPageIndex >= 0 && !(tooltip = (page = this.researchCategory.researches.get(this.selectedPageIndex)).getTooltip(showTooltips)).isEmpty()) {
                this.renderEmberTooltip(graphics, tooltip, mouseX, mouseY);
            }
            if (playLockSound) {
                this.playSound((SoundEvent)EmbersSounds.CODEX_LOCK.get(), showSpeed);
            }
            if (playUnlockSound) {
                this.playSound((SoundEvent)EmbersSounds.CODEX_UNLOCK.get(), showSpeed);
            }
        } else {
            graphics.m_280218_(this.researchPage.getBackground(), basePosX -= 8, basePosY += 8, 0, 0, pageWidth, pageHeight);
            GuiCodex.drawCenteredTextGlowing(this.f_96547_, graphics, Component.m_237113_((String)this.researchPage.getTitle()).m_7532_(), basePosX + pageWidth / 2, basePosY + 19);
            this.researchPage.renderPageContent(graphics, this, basePosX, basePosY, this.f_96547_);
            if (this.researchPage.hasMultiplePages()) {
                this.nextPageSelected = false;
                this.previousPageSelected = false;
                int arrowY = basePosY + pageHeight - 13;
                RenderSystem.enableBlend();
                if (this.researchPage.getNextPage() != this.researchPage) {
                    int rightArrowX = basePosX + pageWidth - 9 - 8;
                    this.drawModalRectGlowing(graphics, this.researchPage.getBackground(), rightArrowX, arrowY, pageWidth, 24, 18, 13);
                    boolean bl = this.nextPageSelected = mouseX >= rightArrowX - 3 && mouseY >= arrowY - 3 && mouseX <= rightArrowX + 3 + 18 && mouseY <= arrowY + 3 + 13;
                }
                if (this.researchPage.getPreviousPage() != this.researchPage) {
                    int leftArrowX = basePosX - 9 + 8;
                    this.drawModalRectGlowing(graphics, this.researchPage.getBackground(), leftArrowX, arrowY, pageWidth, 37, 18, 13);
                    this.previousPageSelected = mouseX >= leftArrowX - 3 && mouseY >= arrowY - 3 && mouseX <= leftArrowX + 3 + 18 && mouseY <= arrowY + 3 + 13;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        this.doRenderTooltip(graphics);
        RenderSystem.disableBlend();
    }

    private String getSearchStringPrint() {
        String searchStringFormat = this.searchDelay > 0 ? "" : (this.searchResult.isEmpty() ? ChatFormatting.DARK_GRAY.toString() : ChatFormatting.GREEN.toString());
        return searchStringFormat + this.searchString;
    }

    public void renderEmberTooltip(GuiGraphics graphics, List<Component> text, int x, int y) {
        List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)ItemStack.f_41583_, text, (int)x, (int)this.f_96543_, (int)this.f_96544_, (Font)this.f_96547_);
        GuiCodex.drawHoveringTextGlowing(graphics, components, x, y, this.f_96543_, this.f_96544_, -1, this.f_96547_);
    }

    public float getVert(float i, float f1, float f2) {
        float coeff = Math.abs(i) + (float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick();
        float vert = Math.abs(10.0f * ((1.0f - Math.abs(i / 80.0f)) * (float)(Math.sin(coeff * f1) + (double)0.4f * Math.sin(coeff * f2))));
        return vert;
    }

    public void m_7379_() {
        if (this.previousScreen != null) {
            Minecraft.m_91087_().m_91152_(this.previousScreen);
            this.previousScreen = null;
        } else {
            super.m_7379_();
        }
        for (ResearchCategory category : ResearchManager.researches) {
            for (ResearchBase base : category.researches) {
                base.selectedAmount = 0.0f;
            }
        }
    }

    public void m_86600_() {
        super.m_86600_();
        --this.searchDelay;
        if (this.searchDelay == 0) {
            this.searchResult.clear();
            Map<ResearchBase, Integer> results = ResearchManager.findByTag(this.searchString);
            results.entrySet().stream().sorted((x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue())).map(Map.Entry::getKey).forEach(result -> this.searchResult.add((ResearchBase)result));
        }
    }

    public static void drawHoveringTextGlowing(GuiGraphics graphics, List<ClientTooltipComponent> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        if (!textLines.isEmpty()) {
            int i = 0;
            int j = textLines.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : textLines) {
                int k = clienttooltipcomponent.m_142069_(font);
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.m_142103_();
            }
            int j2 = mouseX + 12;
            int k2 = mouseY - 12;
            if (j2 + i > screenWidth) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > screenHeight) {
                k2 = screenHeight - j - 6;
            }
            graphics.m_280168_().m_85836_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
            int backgroundColor = new Color(0, 0, 0, 128).getRGB();
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f);
            float cosine = 0.5f * ((float)Math.cos(Math.toRadians(4.0f * ((float)EmbersClientEvents.ticks + Minecraft.m_91087_().getPartialTick()))) + 1.0f);
            int borderColorStart = Misc.intColor(1.0f, Misc.multColor(EmbersColors.EMBER, sine));
            int borderColorEnd = Misc.intColor(1.0f, Misc.multColor(EmbersColors.EMBER, cosine));
            graphics.m_280120_(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, backgroundColor, backgroundColor);
            graphics.m_280120_(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, backgroundColor, backgroundColor);
            graphics.m_280120_(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.m_280120_(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.m_280120_(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.m_280120_(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, borderColorStart, borderColorEnd);
            graphics.m_280120_(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, borderColorStart, borderColorEnd);
            graphics.m_280120_(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, borderColorStart, borderColorStart);
            graphics.m_280120_(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, borderColorEnd, borderColorEnd);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            graphics.m_280168_().m_85837_(0.0, 0.0, 400.0);
            int l1 = k2;
            for (int i2 = 0; i2 < textLines.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent1 = textLines.get(i2);
                clienttooltipcomponent1.m_142440_(font, j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.m_142103_() + (i2 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.m_109911_();
            graphics.m_280168_().m_85849_();
            l1 = k2;
        }
    }
}

