/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.gui;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.item.AlchemyHintItem;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SlateMenu
extends AbstractContainerMenu {
    public static int slateHeight = 158;
    public static int slateWidth = 192;
    public static int heightMargin = 12;
    public static int widthMargin = 15;
    public static int invHeight = 100;
    public static int invWidth = 176;
    public static int slotIndent = -28;
    public static int slotWidth = 26;
    public static int slotHeight = 22;
    public static int slotCount = 5;
    public static int layerHeight = (slateHeight - slotHeight - 2 * heightMargin) / slotCount;
    public static int layerWidth = slateWidth - slotWidth - 2 * widthMargin;
    public ItemStackHandler inventory;
    public ItemStack slate;

    public SlateMenu(int id, Inventory inv, ItemStack slate) {
        super((MenuType)RegistryManager.SLATE_MENU.get(), id);
        this.slate = slate;
        this.inventory = new ItemStackHandler(slotCount){

            public void onContentsChanged(int slot) {
                SlateMenu.this.slate.m_41784_().m_128365_("inventory", (Tag)this.serializeNBT());
            }
        };
        CompoundTag nbt = slate.m_41698_("inventory");
        if (!nbt.m_128456_()) {
            this.inventory.deserializeNBT(nbt);
        }
        Slot master = this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, slotIndent, heightMargin + layerHeight / 2 + 16));
        for (int j = 1; j < slotCount; ++j) {
            this.m_38897_((Slot)new SlateSlot((IItemHandler)this.inventory, j, slotIndent, heightMargin + j * layerHeight + layerHeight / 2 + 16, master));
        }
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inv, k + l * 9 + 9, 8 + k * 18, l * 18 + (slateHeight + 18)));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (ItemStack.m_150942_((ItemStack)inv.m_8020_(i), (ItemStack)slate)) {
                this.m_38897_(new LockedSlot((Container)inv, i, 8 + i * 18, slateHeight + 76));
                continue;
            }
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, slateHeight + 76));
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.slate || player.m_21206_() == this.slate;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.inventory.getSlots() ? !this.m_38903_(itemstack1, this.inventory.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.inventory.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player p_39649_) {
        super.m_6877_(p_39649_);
    }

    public static SlateMenu fromBuffer(int id, Inventory inv, FriendlyByteBuf buf) {
        return new SlateMenu(id, inv, buf.m_130267_());
    }

    public static class SlateSlot
    extends SlotItemHandler {
        public Slot master;

        public SlateSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Slot master) {
            super(itemHandler, index, xPosition, yPosition);
            this.master = master;
        }

        public boolean m_5857_(ItemStack stack) {
            ItemStack masterItem = this.master.m_7993_();
            if (masterItem.m_41619_()) {
                return false;
            }
            ArrayList<ItemStack> masterInputs = AlchemyHintItem.getInputs(masterItem);
            ArrayList<ItemStack> inputs = AlchemyHintItem.getInputs(stack);
            if (masterInputs.size() != inputs.size()) {
                return false;
            }
            for (int i = 0; i < masterInputs.size(); ++i) {
                if (ItemStack.m_41656_((ItemStack)masterInputs.get(i), (ItemStack)inputs.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class LockedSlot
    extends Slot {
        public LockedSlot(Container container, int id, int x, int y) {
            super(container, id, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }

        public boolean m_150651_(Player player) {
            return false;
        }
    }
}

