/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.api.item.IInflictorGem;
import com.rekindled.embers.api.item.IInflictorGemHolder;
import com.rekindled.embers.item.AshenArmorItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AshenArmorGemItem
extends AshenArmorItem
implements IInflictorGemHolder {
    public Supplier<Integer> gemSlots;

    public AshenArmorGemItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, Supplier<Integer> gemSlots) {
        super(material, type, properties);
        this.gemSlots = gemSlots;
    }

    @Override
    public int getGemSlots(ItemStack holder) {
        return this.gemSlots.get();
    }

    @Override
    public boolean canAttachGem(ItemStack holder, ItemStack gem) {
        return gem.m_41720_() instanceof IInflictorGem;
    }

    @Override
    public void attachGem(ItemStack holder, ItemStack gem, int slot) {
        holder.m_41784_().m_128365_("gem" + slot, (Tag)gem.serializeNBT());
    }

    @Override
    public ItemStack detachGem(ItemStack holder, int slot) {
        if (holder.m_41784_().m_128441_("gem" + slot)) {
            ItemStack gem = ItemStack.m_41712_((CompoundTag)holder.m_41784_().m_128469_("gem" + slot));
            holder.m_41784_().m_128473_("gem" + slot);
            return gem;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void clearGems(ItemStack holder) {
        CompoundTag tagCompound = holder.m_41784_();
        if (tagCompound == null) {
            return;
        }
        for (int i = 0; i < this.getGemSlots(holder); ++i) {
            if (!tagCompound.m_128441_("gem" + i)) continue;
            tagCompound.m_128473_("gem" + i);
        }
    }

    @Override
    public ItemStack[] getAttachedGems(ItemStack holder) {
        ItemStack[] stacks = new ItemStack[this.getGemSlots(holder)];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = holder.m_41784_().m_128441_("gem" + i) ? ItemStack.m_41712_((CompoundTag)holder.m_41784_().m_128469_("gem" + i)) : ItemStack.f_41583_;
        }
        return stacks;
    }

    @Override
    public float getTotalDamageResistance(LivingEntity entity, DamageSource source, ItemStack holder) {
        float reduction = 0.0f;
        if (!this.isBroken(holder)) {
            for (ItemStack stack : this.getAttachedGems(holder)) {
                IInflictorGem gem;
                Item item = stack.m_41720_();
                if (!(item instanceof IInflictorGem) || !(gem = (IInflictorGem)item).getAttunedSource(stack).equals(source.m_269415_().f_268677_())) continue;
                reduction += gem.getDamageResistance(stack, reduction);
            }
        }
        return reduction;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        ItemStack[] attached = this.getAttachedGems(stack);
        int filledSlots = 0;
        for (ItemStack stacks : attached) {
            if (stacks.m_41619_()) continue;
            ++filledSlots;
        }
        if (this.getGemSlots(stack) > filledSlots) {
            tooltip.add((Component)Component.m_237110_((String)"embers.tooltip.inflictor.slots", (Object[])new Object[]{this.getGemSlots(stack) - filledSlots}).m_130940_(ChatFormatting.GRAY));
        }
        for (ItemStack stacks : attached) {
            if (stacks.m_41619_()) continue;
            if (stacks.m_41784_().m_128441_("type")) {
                tooltip.add((Component)Component.m_237110_((String)"embers.tooltip.inflictor", (Object[])new Object[]{stacks.m_41784_().m_128461_("type")}).m_130940_(ChatFormatting.GRAY));
                continue;
            }
            tooltip.add((Component)Component.m_237115_((String)"embers.tooltip.inflictor.none").m_130940_(ChatFormatting.GRAY));
        }
    }
}

