/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.api.event.EmberProjectileEvent;
import com.rekindled.embers.api.item.IProjectileWeapon;
import com.rekindled.embers.api.projectile.EffectDamage;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.api.projectile.ProjectileRay;
import com.rekindled.embers.damage.DamageEmber;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.util.EmberInventoryUtil;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlazingRayItem
extends Item
implements IProjectileWeapon {
    public static Random rand = new Random();

    public BlazingRayItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!level.f_46443_) {
            double charge = (double)Math.min((Integer)ConfigManager.BLAZING_RAY_MAX_CHARGE.get(), this.m_8105_(stack) - timeLeft) / (double)((Integer)ConfigManager.BLAZING_RAY_MAX_CHARGE.get()).intValue();
            double handmod = entity.m_7655_() == InteractionHand.MAIN_HAND ? 1.0 : -1.0;
            double posX = entity.m_20185_() + entity.m_20154_().f_82479_ + (handmod *= entity.m_5737_() == HumanoidArm.RIGHT ? 1.0 : -1.0) * ((double)entity.m_20205_() / 2.0) * Math.sin(Math.toRadians(-entity.m_6080_() - 90.0f));
            double posY = entity.m_20186_() + (double)entity.m_20192_() - 0.2 + entity.m_20154_().f_82480_;
            double posZ = entity.m_20189_() + entity.m_20154_().f_82481_ + handmod * ((double)entity.m_20205_() / 2.0) * Math.cos(Math.toRadians(-entity.m_6080_() - 90.0f));
            double targX = entity.m_20185_() + entity.m_20154_().f_82479_ * (Double)ConfigManager.BLAZING_RAY_MAX_DISTANCE.get() + (Double)ConfigManager.BLAZING_RAY_MAX_SPREAD.get() * (1.0 - charge) * ((double)rand.nextFloat() - 0.5);
            double targY = entity.m_20186_() + entity.m_20154_().f_82480_ * (Double)ConfigManager.BLAZING_RAY_MAX_DISTANCE.get() + (Double)ConfigManager.BLAZING_RAY_MAX_SPREAD.get() * (1.0 - charge) * ((double)rand.nextFloat() - 0.5);
            double targZ = entity.m_20189_() + entity.m_20154_().f_82481_ * (Double)ConfigManager.BLAZING_RAY_MAX_DISTANCE.get() + (Double)ConfigManager.BLAZING_RAY_MAX_SPREAD.get() * (1.0 - charge) * ((double)rand.nextFloat() - 0.5);
            DamageEmber damage = new DamageEmber((Holder<DamageType>)((Registry)level.m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(EmbersDamageTypes.EMBER_KEY), (Entity)entity, true);
            EffectDamage effect = new EffectDamage(((Double)ConfigManager.BLAZING_RAY_DAMAGE.get()).floatValue(), e -> damage, 1, 1.0);
            ProjectileRay ray = new ProjectileRay((Entity)entity, new Vec3(posX, posY, posZ), new Vec3(targX, targY, targZ), false, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(entity, stack, charge, ray);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(level);
                }
            }
            level.m_6269_(null, (Entity)entity, (SoundEvent)EmbersSounds.BLAZING_RAY_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.m_41784_().m_128356_("lastUse", level.m_46467_());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_() || stack.m_41783_().m_128454_("lastUse") + (long)((Integer)ConfigManager.BLAZING_RAY_COOLDOWN.get()).intValue() <= level.m_46467_() || player.m_7500_()) {
            if (EmberInventoryUtil.getEmberTotal(player) >= (Double)ConfigManager.BLAZING_RAY_COST.get() || player.m_7500_()) {
                EmberInventoryUtil.removeEmber(player, (Double)ConfigManager.BLAZING_RAY_COST.get());
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            level.m_6269_(null, (Entity)player, (SoundEvent)EmbersSounds.BLAZING_RAY_EMPTY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

