/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.power.DefaultEmberItemCapability;
import com.rekindled.embers.util.DecimalFormats;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class CopperCellBlockItem
extends BlockItem {
    public CopperCellBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).isPresent();
    }

    public int m_142158_(ItemStack stack) {
        IEmberCapability cap = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        if (cap != null) {
            return Math.round(13.0f - (float)(cap.getEmberCapacity() - cap.getEmber()) * 13.0f / (float)cap.getEmberCapacity());
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int m_142159_(ItemStack pStack) {
        return 0xFF6600;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new DefaultEmberItemCapability(stack, 24000.0);
    }

    public static ItemStack getCharged() {
        ItemStack chargedCell = new ItemStack((ItemLike)RegistryManager.COPPER_CELL_ITEM.get());
        IEmberCapability cap = (IEmberCapability)chargedCell.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        cap.setEmber(cap.getEmberCapacity());
        return chargedCell;
    }

    protected boolean m_7274_(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        IEmberCapability cap = (IEmberCapability)pStack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        if (cap != null) {
            cap.writeToNBT(pStack.m_41698_("BlockEntityTag"));
        }
        return BlockItem.m_40582_((Level)pLevel, (Player)pPlayer, (BlockPos)pPos, (ItemStack)pStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        IEmberCapability cap = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        if (cap != null) {
            DecimalFormat emberFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember");
            tooltip.add((Component)Component.m_237110_((String)"embers.tooltip.item.ember", (Object[])new Object[]{emberFormat.format(cap.getEmber()), emberFormat.format(cap.getEmberCapacity())}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

