/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.rekindled.embers.api.misc.AlchemyResult;
import com.rekindled.embers.recipe.AlchemyContext;
import com.rekindled.embers.recipe.IAlchemyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class AlchemyRecipeBase
implements IAlchemyRecipe {
    public final ResourceLocation id;
    public final Ingredient tablet;
    public final ArrayList<Ingredient> aspects;
    public final ArrayList<Ingredient> inputs;
    public final ItemStack output;
    public final ItemStack failure;
    public Long cachedSeed = null;
    public ArrayList<Ingredient> code = new ArrayList();

    public AlchemyRecipeBase(ResourceLocation id, Ingredient tablet, ArrayList<Ingredient> aspects, ArrayList<Ingredient> inputs, ItemStack output, ItemStack failure) {
        this.id = id;
        this.tablet = tablet;
        this.aspects = aspects;
        this.inputs = inputs;
        this.output = output;
        this.failure = failure;
    }

    @Override
    public ArrayList<Ingredient> getCode(long seed) {
        if (this.cachedSeed == null || this.cachedSeed != seed) {
            this.code.clear();
            Random rand = new Random(seed - (long)this.id.m_135815_().hashCode());
            for (int i = 0; i < this.inputs.size(); ++i) {
                this.code.add(this.aspects.get(rand.nextInt(this.aspects.size())));
            }
            this.cachedSeed = seed;
        }
        return this.code;
    }

    public boolean matches(AlchemyContext context, Level pLevel) {
        if (!this.tablet.test(context.tablet) || this.inputs.size() != context.contents.size()) {
            return false;
        }
        ArrayList<IAlchemyRecipe.PedestalContents> remaining = new ArrayList<IAlchemyRecipe.PedestalContents>(context.contents);
        for (int i = 0; i < this.inputs.size(); ++i) {
            boolean matched = false;
            for (int j = 0; j < remaining.size(); ++j) {
                if (!this.inputs.get(i).test(remaining.get((int)j).input)) continue;
                matched = true;
                remaining.remove(j);
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesCorrect(AlchemyContext context, Level pLevel) {
        this.getCode(context.seed);
        if (!this.tablet.test(context.tablet) || this.code.size() != context.contents.size()) {
            return false;
        }
        ArrayList<IAlchemyRecipe.PedestalContents> remaining = new ArrayList<IAlchemyRecipe.PedestalContents>(context.contents);
        for (int i = 0; i < this.inputs.size(); ++i) {
            boolean matched = false;
            for (int j = 0; j < remaining.size(); ++j) {
                if (!this.code.get(i).test(remaining.get((int)j).aspect) || !this.inputs.get(i).test(remaining.get((int)j).input)) continue;
                matched = true;
                remaining.remove(j);
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(AlchemyContext context, RegistryAccess registry) {
        this.getCode(context.seed);
        int blackPins = 0;
        int whitePins = 0;
        ArrayList<Ingredient> remainingCode = new ArrayList<Ingredient>(this.code);
        block0: for (int i = 0; i < context.contents.size(); ++i) {
            for (int j = 0; j < remainingCode.size(); ++j) {
                if (!remainingCode.get(j).test(context.contents.get((int)i).aspect)) continue;
                ++whitePins;
                remainingCode.remove(j);
                continue block0;
            }
        }
        ArrayList<IAlchemyRecipe.PedestalContents> remaining = new ArrayList<IAlchemyRecipe.PedestalContents>(context.contents);
        block2: for (int i = 0; i < this.inputs.size(); ++i) {
            for (int j = 0; j < remaining.size(); ++j) {
                if (!this.code.get(i).test(remaining.get((int)j).aspect) || !this.inputs.get(i).test(remaining.get((int)j).input)) continue;
                ++blackPins;
                remaining.remove(j);
                continue block2;
            }
        }
        whitePins -= blackPins;
        if (blackPins < this.code.size()) {
            ItemStack waste = this.failure.m_41777_();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("blackPins", blackPins);
            nbt.m_128405_("whitePins", whitePins);
            ListTag aspectNBT = new ListTag();
            ListTag inputNBT = new ListTag();
            for (IAlchemyRecipe.PedestalContents contents : context.contents) {
                aspectNBT.add((Object)contents.aspect.serializeNBT());
                inputNBT.add((Object)contents.input.serializeNBT());
            }
            nbt.m_128365_("aspects", (Tag)aspectNBT);
            nbt.m_128365_("inputs", (Tag)inputNBT);
            waste.m_41751_(nbt);
            return waste;
        }
        return this.output;
    }

    @Override
    public AlchemyResult getResult(AlchemyContext context) {
        this.getCode(context.seed);
        int blackPins = 0;
        int whitePins = 0;
        ArrayList<Ingredient> remainingCode = new ArrayList<Ingredient>(this.code);
        block0: for (int i = 0; i < context.contents.size(); ++i) {
            for (int j = 0; j < remainingCode.size(); ++j) {
                if (!remainingCode.get(j).test(context.contents.get((int)i).aspect)) continue;
                ++whitePins;
                remainingCode.remove(j);
                continue block0;
            }
        }
        ArrayList<IAlchemyRecipe.PedestalContents> remaining = new ArrayList<IAlchemyRecipe.PedestalContents>(context.contents);
        block2: for (int i = 0; i < this.inputs.size(); ++i) {
            for (int j = 0; j < remaining.size(); ++j) {
                if (!this.code.get(i).test(remaining.get((int)j).aspect) || !this.inputs.get(i).test(remaining.get((int)j).input)) continue;
                ++blackPins;
                remaining.remove(j);
                continue block2;
            }
        }
        whitePins -= blackPins;
        ArrayList<IAlchemyRecipe.PedestalContents> contents = new ArrayList<IAlchemyRecipe.PedestalContents>(context.contents);
        ArrayList<IAlchemyRecipe.PedestalContents> sortedContents = new ArrayList<IAlchemyRecipe.PedestalContents>();
        block4: for (Ingredient input : this.inputs) {
            for (IAlchemyRecipe.PedestalContents pedestal : contents) {
                if (!input.test(pedestal.input)) continue;
                sortedContents.add(pedestal);
                contents.remove(pedestal);
                continue block4;
            }
        }
        return new AlchemyResult(sortedContents, this.getResultItem(), blackPins, whitePins);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public Ingredient getCenterInput() {
        return this.tablet;
    }

    @Override
    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    @Override
    public List<Ingredient> getAspects() {
        return this.aspects;
    }

    @Override
    public ItemStack getResultItem() {
        return this.output;
    }

    @Override
    public ItemStack getfailureItem() {
        return this.failure;
    }
}

