/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.recipe.AnvilDisplayRecipe;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.recipe.IVisuallySplitRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilRepairMateriaRecipe
implements IDawnstoneAnvilRecipe,
IVisuallySplitRecipe<IDawnstoneAnvilRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public static List<IDawnstoneAnvilRecipe> visualRecipes = new ArrayList<IDawnstoneAnvilRecipe>();
    Ingredient materia = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ISOLATED_MATERIA.get()});
    Ingredient blacklist = Ingredient.m_204132_(EmbersItemTags.MATERIA_BLACKLIST);

    public AnvilRepairMateriaRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5818_(Container context, Level pLevel) {
        ItemStack tool = context.m_8020_(0);
        return tool.isRepairable() && tool.m_41768_() && !this.blacklist.test(tool) && this.materia.test(context.m_8020_(1));
    }

    @Override
    public List<ItemStack> getOutput(Container context) {
        ItemStack result = context.m_8020_(0).m_41777_();
        result.m_41721_(Math.max(0, result.m_41773_() - result.m_41776_()));
        return List.of(result);
    }

    @Override
    public List<IDawnstoneAnvilRecipe> getVisualRecipes() {
        visualRecipes.clear();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206115_()) {
            ItemStack toolStack = new ItemStack((ItemLike)holder.get());
            if (!toolStack.isRepairable() || this.blacklist.test(toolStack)) continue;
            ItemStack brokenTool = toolStack.m_41777_();
            brokenTool.m_41721_(brokenTool.m_41776_() / 2);
            visualRecipes.add(new AnvilDisplayRecipe(this.id, List.of(toolStack), List.of(brokenTool), this.materia));
        }
        return visualRecipes;
    }

    @Override
    public List<ItemStack> getDisplayInputBottom() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayInputTop() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayOutput() {
        return List.of();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRepairMateriaRecipe> {
        public AnvilRepairMateriaRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new AnvilRepairMateriaRecipe(recipeId);
        }

        @Nullable
        public AnvilRepairMateriaRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AnvilRepairMateriaRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilRepairMateriaRecipe recipe) {
        }
    }
}

