/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.recipe.AnvilDisplayRecipe;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.recipe.IVisuallySplitRecipe;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class AnvilRepairRecipe
implements IDawnstoneAnvilRecipe,
IVisuallySplitRecipe<IDawnstoneAnvilRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public static List<IDawnstoneAnvilRecipe> visualRecipes = new ArrayList<IDawnstoneAnvilRecipe>();
    Ingredient blacklist = Ingredient.m_204132_(EmbersItemTags.REPAIR_BLACKLIST);

    public AnvilRepairRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5818_(Container context, Level pLevel) {
        ItemStack tool = context.m_8020_(0);
        return tool.isRepairable() && tool.m_41768_() && !this.blacklist.test(tool) && tool.m_41720_().m_6832_(tool, context.m_8020_(1));
    }

    @Override
    public List<ItemStack> getOutput(Container context) {
        ItemStack result = context.m_8020_(0).m_41777_();
        result.m_41721_(Math.max(0, result.m_41773_() - result.m_41776_()));
        return List.of(result);
    }

    @Override
    public List<IDawnstoneAnvilRecipe> getVisualRecipes() {
        visualRecipes.clear();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206115_()) {
            Ingredient repairMaterial = Misc.getRepairIngredient((Item)holder.get());
            ItemStack toolStack = new ItemStack((ItemLike)holder.get());
            if (repairMaterial.m_43947_() || ForgeHooks.hasNoElements((Ingredient)repairMaterial) || !toolStack.isRepairable() || this.blacklist.test(toolStack)) continue;
            ItemStack brokenTool = toolStack.m_41777_();
            brokenTool.m_41721_(brokenTool.m_41776_() / 2);
            visualRecipes.add(new AnvilDisplayRecipe(this.id, List.of(toolStack), List.of(brokenTool), repairMaterial));
        }
        return visualRecipes;
    }

    @Override
    public List<ItemStack> getDisplayInputBottom() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayInputTop() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayOutput() {
        return List.of();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRepairRecipe> {
        public AnvilRepairRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new AnvilRepairRecipe(recipeId);
        }

        @Nullable
        public AnvilRepairRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AnvilRepairRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilRepairRecipe recipe) {
        }
    }
}

