/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.MeltingRecipe;
import com.rekindled.embers.util.FluidOutput;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class MeltingRecipeBuilder {
    public ResourceLocation id;
    public Ingredient ingredient;
    public FluidOutput output;
    public FluidOutput bonus = FluidOutput.EMPTY;

    public static MeltingRecipeBuilder create(Ingredient ingredient) {
        MeltingRecipeBuilder builder = new MeltingRecipeBuilder();
        builder.ingredient = ingredient;
        return builder;
    }

    public static MeltingRecipeBuilder create(TagKey<Item> tag) {
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.create(Ingredient.m_204132_(tag));
        builder.id = tag.f_203868_();
        return builder;
    }

    public static MeltingRecipeBuilder create(ItemStack itemStack) {
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.create(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static MeltingRecipeBuilder create(Item item) {
        return MeltingRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public MeltingRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public MeltingRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public MeltingRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public MeltingRecipeBuilder bonusName(String stuff) {
        this.id = new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + stuff);
        return this;
    }

    public MeltingRecipeBuilder output(FluidStack output) {
        this.output = new FluidOutput(output);
        return this;
    }

    public MeltingRecipeBuilder output(Fluid fluid, int amount) {
        this.output(new FluidStack(fluid, amount));
        return this;
    }

    public MeltingRecipeBuilder output(TagKey<Fluid> tag, int amount) {
        this.output = new FluidOutput(tag, amount);
        return this;
    }

    public MeltingRecipeBuilder bonus(FluidStack bonus) {
        this.bonus = new FluidOutput(bonus);
        return this;
    }

    public MeltingRecipeBuilder bonus(Fluid fluid, int amount) {
        this.bonus(new FluidStack(fluid, amount));
        return this;
    }

    public MeltingRecipeBuilder bonus(TagKey<Fluid> tag, int amount) {
        this.bonus = new FluidOutput(tag, amount);
        return this;
    }

    public MeltingRecipe build() {
        return new MeltingRecipe(this.id, this.ingredient, this.output, this.bonus);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final MeltingRecipe recipe;

        public Finished(MeltingRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.recipe.ingredient.m_43942_());
            json.add("output", (JsonElement)this.recipe.output.toJson());
            if (!this.recipe.bonus.isEmpty()) {
                json.add("bonus", (JsonElement)this.recipe.bonus.toJson());
            }
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.MELTING_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

