/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.rekindled.embers.recipe.BlockStateContext;
import com.rekindled.embers.recipe.IMetalCoefficientRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MetalCoefficientRecipe
implements IMetalCoefficientRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final TagKey<Block> blockTag;
    public final double coefficient;

    public MetalCoefficientRecipe(ResourceLocation id, TagKey<Block> blockTag, double coefficient) {
        this.id = id;
        this.blockTag = blockTag;
        this.coefficient = coefficient;
    }

    public boolean matches(BlockStateContext context, Level pLevel) {
        return context.state.m_204336_(this.blockTag);
    }

    @Override
    public double getCoefficient(BlockStateContext context) {
        return this.coefficient;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public List<ItemStack> getDisplayInput() {
        ArrayList list = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.f_256975_.m_206058_(this.blockTag)) {
            list.add(new ItemStack((ItemLike)holder.get()));
        }
        return list;
    }

    @Override
    public double getDisplayCoefficient() {
        return this.coefficient;
    }

    public static class Serializer
    implements RecipeSerializer<MetalCoefficientRecipe> {
        public MetalCoefficientRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ResourceLocation blockTag = new ResourceLocation(json.get("block_tag").getAsString());
            double coefficient = GsonHelper.m_144784_((JsonObject)json, (String)"coefficient");
            return new MetalCoefficientRecipe(recipeId, (TagKey<Block>)BlockTags.create((ResourceLocation)blockTag), coefficient);
        }

        @Nullable
        public MetalCoefficientRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ResourceLocation blockTag = buffer.m_130281_();
            double coefficient = buffer.readDouble();
            return new MetalCoefficientRecipe(recipeId, (TagKey<Block>)BlockTags.create((ResourceLocation)blockTag), coefficient);
        }

        public void toNetwork(FriendlyByteBuf buffer, MetalCoefficientRecipe recipe) {
            buffer.m_130085_(recipe.blockTag.f_203868_());
            buffer.writeDouble(recipe.coefficient);
        }
    }
}

