/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.recipe.FluidIngredient;
import com.rekindled.embers.recipe.IMixingRecipe;
import com.rekindled.embers.recipe.MixingContext;
import com.rekindled.embers.util.FluidOutput;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class MixingRecipe
implements IMixingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final ArrayList<FluidIngredient> inputs;
    public final FluidOutput output;

    public MixingRecipe(ResourceLocation id, ArrayList<FluidIngredient> inputs, FluidOutput output) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean matches(MixingContext context, Level pLevel) {
        HashSet<FluidIngredient> remaining = new HashSet<FluidIngredient>();
        remaining.addAll(this.inputs);
        for (IFluidHandler handler : context.fluids) {
            boolean matched = false;
            for (FluidIngredient fluid : remaining) {
                for (FluidStack stack : fluid.getAllFluids()) {
                    if (!fluid.test(handler.drain(stack, IFluidHandler.FluidAction.SIMULATE))) continue;
                    remaining.remove(fluid);
                    matched = true;
                    break;
                }
                if (!matched) continue;
                break;
            }
            if (matched || handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            return false;
        }
        return remaining.isEmpty();
    }

    @Override
    public FluidStack getOutput(MixingContext context) {
        return this.output.getStack();
    }

    @Override
    public FluidStack process(MixingContext context) {
        HashSet<FluidIngredient> remaining = new HashSet<FluidIngredient>();
        remaining.addAll(this.inputs);
        block0: for (IFluidHandler handler : context.fluids) {
            for (FluidIngredient fluid : remaining) {
                boolean matched = false;
                for (FluidStack stack : fluid.getAllFluids()) {
                    if (!fluid.test(handler.drain(stack, IFluidHandler.FluidAction.SIMULATE))) continue;
                    handler.drain(stack, IFluidHandler.FluidAction.EXECUTE);
                    matched = true;
                    break;
                }
                if (!matched) continue;
                continue block0;
            }
        }
        return this.output.getStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public ArrayList<FluidIngredient> getDisplayInputFluids() {
        return this.inputs;
    }

    @Override
    public FluidStack getDisplayOutput() {
        return this.output.getStack();
    }

    public static class Serializer
    implements RecipeSerializer<MixingRecipe> {
        public MixingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidOutput output = FluidOutput.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            ArrayList<FluidIngredient> inputs = new ArrayList<FluidIngredient>();
            JsonArray inputJson = GsonHelper.m_13832_((JsonObject)json, (String)"inputs", null);
            if (inputJson != null) {
                for (JsonElement element : inputJson) {
                    inputs.add(FluidIngredient.deserialize(element, "fluid"));
                }
            }
            return new MixingRecipe(recipeId, inputs, output);
        }

        @Nullable
        public MixingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ArrayList inputs = (ArrayList)buffer.m_236838_(i -> new ArrayList(), buf -> FluidIngredient.read(buf));
            FluidOutput output = FluidOutput.fromNetwork(buffer);
            return new MixingRecipe(recipeId, inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, MixingRecipe recipe) {
            buffer.m_236828_(recipe.inputs, (buf, input) -> input.write((FriendlyByteBuf)buf));
            recipe.output.toNetwork(buffer);
        }
    }
}

